/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.block.tile.TileEntityDynamicTexture;
import com.infinityraider.infinitylib.item.BlockItemDynamicTexture;
import com.infinityraider.infinitylib.render.IRenderUtilities;
import com.infinityraider.infinitylib.render.model.InfModelLoader;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IModelGeometry;

@OnlyIn(value=Dist.CLIENT)
public class InfModelLoaderDynamicTexture
implements InfModelLoader<Geometry> {
    private static final ResourceLocation ID = new ResourceLocation(InfinityLib.instance.getModId(), "dynamic_texture");
    private static final String DYNAMIC_TEXTURE = "dynamic";
    private static final InfModelLoaderDynamicTexture INSTANCE = new InfModelLoaderDynamicTexture();

    public static InfModelLoaderDynamicTexture getInstance() {
        return INSTANCE;
    }

    private InfModelLoaderDynamicTexture() {
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    public void func_195410_a(@Nonnull IResourceManager resourceManager) {
    }

    @Nonnull
    public Geometry read(@Nonnull JsonDeserializationContext context, JsonObject modelContents) {
        if (!modelContents.has("textures")) {
            throw new RuntimeException("Dynamic texture model needs a \"textures\" field.");
        }
        JsonObject textureJson = modelContents.getAsJsonObject("textures");
        if (!textureJson.has("default")) {
            throw new RuntimeException("Dynamic texture model needs a \"default\" texture in the textures.");
        }
        String defaultTexture = textureJson.get("default").getAsString();
        ArrayList parts = Lists.newArrayList();
        if (modelContents.has("elements")) {
            for (JsonElement jsonelement : JSONUtils.func_151214_t((JsonObject)modelContents, (String)"elements")) {
                parts.add(context.deserialize(jsonelement, BlockPart.class));
            }
        }
        ItemCameraTransforms itemCameraTransforms = ItemCameraTransforms.field_178357_a;
        if (modelContents.has("display")) {
            JsonObject transforms = JSONUtils.func_152754_s((JsonObject)modelContents, (String)"display");
            itemCameraTransforms = (ItemCameraTransforms)context.deserialize((JsonElement)transforms, ItemCameraTransforms.class);
        }
        return new Geometry(this.flagDynamicTextures(parts), defaultTexture, itemCameraTransforms);
    }

    private List<BlockPart> flagDynamicTextures(List<BlockPart> parts) {
        parts.forEach(part -> part.field_178240_c.replaceAll((dir, face) -> {
            if (DYNAMIC_TEXTURE.equals(face.field_178242_d)) {
                return new DynamicFace((BlockPartFace)face);
            }
            return face;
        }));
        return parts;
    }

    public static class DynamicTextureModel
    implements IBakedModel,
    IRenderUtilities {
        private static final ModelProperty<ItemStack> PROPERTY_MATERIAL = TileEntityDynamicTexture.PROPERTY_MATERIAL;
        private final Map<TextureAtlasSprite, IBakedModel> quadCache = Maps.newConcurrentMap();
        private final IBakedModel defaultModel;
        private final TextureAtlasSprite defaultSprite;
        private final List<BlockPart> parts;
        private final IModelConfiguration owner;
        private final ItemCameraTransforms transforms;
        private final Function<RenderMaterial, TextureAtlasSprite> spriteGetter;
        private final IModelTransform transform;
        private final ItemOverrideList overrides;
        private final ResourceLocation modelLocation;

        private DynamicTextureModel(List<BlockPart> parts, IModelConfiguration owner, ItemCameraTransforms transforms, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform transform, ItemOverrideList overrides, ResourceLocation modelLocation, String defaultTexture) {
            this.parts = parts;
            this.owner = owner;
            this.transforms = transforms;
            this.spriteGetter = spriteGetter;
            this.transform = transform;
            this.overrides = overrides;
            this.modelLocation = modelLocation;
            this.defaultSprite = this.spriteGetter.apply(this.getRenderMaterial(defaultTexture));
            this.defaultModel = this.bakeSubModel(this.getDefaultSprite());
        }

        public IBakedModel getDefaultModel() {
            return this.defaultModel;
        }

        @Nonnull
        public TextureAtlasSprite getDefaultSprite() {
            return this.defaultSprite;
        }

        @Nonnull
        protected TextureAtlasSprite getMaterialSprite(@Nullable ItemStack material) {
            if (material == null || material.func_190926_b()) {
                return this.getDefaultSprite();
            }
            if (material.func_77973_b() instanceof BlockItem) {
                Block block = ((BlockItem)material.func_77973_b()).func_179223_d();
                return this.getModelForState(block.func_176223_P()).func_177554_e();
            }
            return this.getDefaultSprite();
        }

        @Nonnull
        public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData modelData) {
            return modelData;
        }

        @Nonnull
        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand) {
            return this.getQuads(state, side, rand, this.getDefaultSprite());
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            if (!extraData.hasProperty(PROPERTY_MATERIAL)) {
                return this.func_200117_a(state, side, rand);
            }
            TextureAtlasSprite sprite = this.getMaterialSprite((ItemStack)extraData.getData(PROPERTY_MATERIAL));
            return this.getQuads(state, side, rand, sprite);
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull TextureAtlasSprite material) {
            return this.getSubModel(material).func_200117_a(state, side, rand);
        }

        public IBakedModel getSubModel(@Nonnull TextureAtlasSprite material) {
            if (material.func_195668_m().equals((Object)this.getDefaultSprite().func_195668_m())) {
                return this.getDefaultModel();
            }
            return this.quadCache.computeIfAbsent(material, this::bakeSubModel);
        }

        protected IBakedModel bakeSubModel(@Nonnull TextureAtlasSprite material) {
            ArrayList generalQuads = Lists.newArrayList();
            EnumMap faceQuads = Maps.newEnumMap(Direction.class);
            Arrays.stream(Direction.values()).forEach(dir -> {
                List cfr_ignored_0 = faceQuads.put(dir, Lists.newArrayList());
            });
            for (BlockPart part : this.parts) {
                for (Direction direction : part.field_178240_c.keySet()) {
                    BlockPartFace face = (BlockPartFace)part.field_178240_c.get(direction);
                    TextureAtlasSprite sprite = face instanceof DynamicFace ? material : this.spriteGetter.apply(this.owner.resolveTexture(face.field_178242_d));
                    if (face.field_178244_b == null) {
                        generalQuads.add(BlockModel.makeBakedQuad((BlockPart)part, (BlockPartFace)face, (TextureAtlasSprite)sprite, (Direction)direction, (IModelTransform)this.transform, (ResourceLocation)this.modelLocation));
                        continue;
                    }
                    ((List)faceQuads.get(this.transform.func_225615_b_().rotateTransform(face.field_178244_b))).add(BlockModel.makeBakedQuad((BlockPart)part, (BlockPartFace)face, (TextureAtlasSprite)sprite, (Direction)direction, (IModelTransform)this.transform, (ResourceLocation)this.modelLocation));
                }
            }
            return new SimpleBakedModel((List)ImmutableList.copyOf((Collection)generalQuads), (Map)ImmutableMap.copyOf((Map)Maps.transformValues((Map)faceQuads, ImmutableList::copyOf)), this.owner.useSmoothLighting(), this.owner.isSideLit(), this.owner.isShadedInGui(), material, this.func_177552_f(), this.func_188617_f());
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_230044_c_() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        @Nonnull
        public TextureAtlasSprite func_177554_e() {
            return this.getDefaultSprite();
        }

        @Nonnull
        public TextureAtlasSprite getParticleTexture(@Nonnull IModelData extraData) {
            if (!extraData.hasProperty(PROPERTY_MATERIAL)) {
                return this.func_177554_e();
            }
            return this.getMaterialSprite((ItemStack)extraData.getData(PROPERTY_MATERIAL));
        }

        @Nonnull
        @Deprecated
        public ItemCameraTransforms func_177552_f() {
            return this.transforms;
        }

        @Nonnull
        public ItemOverrideList func_188617_f() {
            return this.overrides;
        }

        public boolean isLayered() {
            return true;
        }

        public List<Pair<IBakedModel, RenderType>> getLayerModels(ItemStack stack, boolean fabulous) {
            return Collections.singletonList(Pair.of((Object)this.getSubModel(this.getMaterialSprite(this.getMaterialFromStack(stack))), (Object)RenderTypeLookup.func_239219_a_((ItemStack)stack, (boolean)fabulous)));
        }

        @Nonnull
        protected ItemStack getMaterialFromStack(@Nonnull ItemStack stack) {
            if (stack.func_77973_b() instanceof BlockItemDynamicTexture) {
                return ((BlockItemDynamicTexture)stack.func_77973_b()).getMaterial(stack);
            }
            return ItemStack.field_190927_a;
        }
    }

    public static class Geometry
    implements IModelGeometry<Geometry>,
    IRenderUtilities {
        private final List<BlockPart> parts;
        private final String defaultTexture;
        private final ItemCameraTransforms transforms;

        private Geometry(List<BlockPart> parts, String defaultTexture, ItemCameraTransforms transforms) {
            this.parts = parts;
            this.defaultTexture = defaultTexture;
            this.transforms = transforms;
        }

        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform transform, ItemOverrideList overrides, ResourceLocation modelLocation) {
            return new DynamicTextureModel(this.parts, owner, this.transforms, spriteGetter, transform, overrides, modelLocation, this.defaultTexture);
        }

        public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            HashSet textures = Sets.newHashSet();
            for (BlockPart part : this.parts) {
                for (BlockPartFace face : part.field_178240_c.values()) {
                    if (face instanceof DynamicFace) continue;
                    RenderMaterial texture = owner.resolveTexture(face.field_178242_d);
                    if (IRenderUtilities.Objects.equals(texture.func_229313_b_(), MissingTextureSprite.func_195675_b())) {
                        missingTextureErrors.add((Pair<String, String>)Pair.of((Object)face.field_178242_d, (Object)owner.getModelName()));
                    }
                    textures.add(texture);
                }
            }
            RenderMaterial texture = this.getRenderMaterial(this.defaultTexture);
            if (IRenderUtilities.Objects.equals(texture.func_229313_b_(), MissingTextureSprite.func_195675_b())) {
                missingTextureErrors.add((Pair<String, String>)Pair.of((Object)this.defaultTexture, (Object)owner.getModelName()));
            }
            textures.add(owner.resolveTexture(this.defaultTexture));
            return textures;
        }
    }

    private static class DynamicFace
    extends BlockPartFace {
        public DynamicFace(BlockPartFace parent) {
            super(parent.field_178244_b, parent.field_178245_c, parent.field_178242_d, parent.field_178243_e);
        }
    }
}

