/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.model;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.render.model.InfModelLoader;
import com.infinityraider.infinitylib.render.model.TransformingFaceBakery;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.ModelTransformComposition;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import net.minecraftforge.client.model.geometry.IMultipartModelGeometry;

@OnlyIn(value=Dist.CLIENT)
public class InfModelLoaderComposite
implements InfModelLoader<Geometry> {
    private static final ResourceLocation ID = new ResourceLocation(InfinityLib.instance.getModId(), "composite");
    private static final InfModelLoaderComposite INSTANCE = new InfModelLoaderComposite();

    public static InfModelLoaderComposite getInstance() {
        return INSTANCE;
    }

    private InfModelLoaderComposite() {
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    public void func_195410_a(@Nonnull IResourceManager resourceManager) {
    }

    @Nonnull
    public Geometry read(@Nonnull JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        if (!modelContents.has("parts")) {
            throw new RuntimeException("Composite model requires a \"parts\" element.");
        }
        Optional<JsonObject> transformations = modelContents.has("transformations") ? Optional.of(modelContents.getAsJsonObject("transformations")) : Optional.empty();
        ImmutableMap.Builder parts = ImmutableMap.builder();
        for (Map.Entry part : modelContents.get("parts").getAsJsonObject().entrySet()) {
            IModelTransform modelTransform = transformations.filter(json -> json.has((String)part.getKey())).map(json -> InfModelLoaderComposite.readTransformation(json.getAsJsonObject((String)part.getKey()))).orElse((IModelTransform)SimpleModelTransform.IDENTITY);
            parts.put(part.getKey(), (Object)new Submodel((String)part.getKey(), (BlockModel)deserializationContext.deserialize((JsonElement)part.getValue(), BlockModel.class), modelTransform));
        }
        ImmutableMap partsMap = parts.build();
        String particleParent = null;
        if (modelContents.has("particle") && !partsMap.containsKey((Object)(particleParent = modelContents.get("particle").getAsString()))) {
            throw new RuntimeException("Invalid particle inheritance in composite model: \"" + particleParent + "\"");
        }
        return new Geometry((ImmutableMap<String, Submodel>)parts.build(), particleParent);
    }

    private static IModelTransform readTransformation(JsonObject json) {
        Vector3f rotation = InfModelLoaderComposite.parseVector(json, "rotation", ItemTransformVec3f.Deserializer.field_178362_a);
        Matrix4f matrix = new Matrix4f(new Quaternion(rotation.func_195899_a(), rotation.func_195900_b(), rotation.func_195902_c(), true));
        Vector3f translation = InfModelLoaderComposite.parseVector(json, "translation", ItemTransformVec3f.Deserializer.field_178360_b);
        translation.func_195898_a(0.0625f);
        matrix.func_226595_a_(Matrix4f.func_226599_b_((float)translation.func_195899_a(), (float)translation.func_195900_b(), (float)translation.func_195902_c()));
        Vector3f scale = InfModelLoaderComposite.parseVector(json, "scale", ItemTransformVec3f.Deserializer.field_178361_c);
        matrix.func_226595_a_(Matrix4f.func_226593_a_((float)scale.func_195899_a(), (float)scale.func_195900_b(), (float)scale.func_195902_c()));
        final TransformationMatrix transform = new TransformationMatrix(matrix);
        return new IModelTransform(){

            @Nonnull
            public TransformationMatrix func_225615_b_() {
                return transform;
            }
        };
    }

    private static Vector3f parseVector(JsonObject json, String key, Vector3f fallback) {
        if (!json.has(key)) {
            return fallback;
        }
        JsonArray jsonarray = JSONUtils.func_151214_t((JsonObject)json, (String)key);
        if (jsonarray.size() != 3) {
            throw new JsonParseException("Expected 3 " + key + " values, found: " + jsonarray.size());
        }
        float[] afloat = new float[3];
        for (int i = 0; i < afloat.length; ++i) {
            afloat[i] = JSONUtils.func_151220_d((JsonElement)jsonarray.get(i), (String)(key + "[" + i + "]"));
        }
        return new Vector3f(afloat[0], afloat[1], afloat[2]);
    }

    private static class Submodel
    implements IModelGeometryPart {
        private final String name;
        private final BlockModel model;
        private final IModelTransform modelTransform;

        private Submodel(String name, BlockModel model, IModelTransform modelTransform) {
            this.name = name;
            this.model = model;
            this.modelTransform = modelTransform;
        }

        public String name() {
            return this.name;
        }

        public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ResourceLocation modelLocation) {
            throw new UnsupportedOperationException("Attempted to call adQuads on a Submodel instance. Please don't.");
        }

        public IBakedModel bakeModel(ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ResourceLocation modelLocation) {
            IBakedModel baked;
            if (this.model.customData.getCustomGeometry() == null) {
                TransformingFaceBakery.getInstance().pushQuadTransform(this.modelTransform.func_225615_b_());
                baked = this.model.func_225613_a_(bakery, spriteGetter, (IModelTransform)new ModelTransformComposition((IModelTransform)SimpleModelTransform.IDENTITY, modelTransform, this.modelTransform.func_188049_c() || modelTransform.func_188049_c()), modelLocation);
                TransformingFaceBakery.getInstance().popQuadTransform();
            } else {
                baked = this.model.func_225613_a_(bakery, spriteGetter, (IModelTransform)new ModelTransformComposition(this.modelTransform, modelTransform, this.modelTransform.func_188049_c() || modelTransform.func_188049_c()), modelLocation);
            }
            return baked;
        }

        public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return this.model.func_225614_a_(modelGetter, missingTextureErrors);
        }
    }

    private static class BakedModel
    extends CompositeModel {
        private final ImmutableMap<String, IBakedModel> bakedParts;
        private final String particleParent;

        public BakedModel(boolean isGui3d, boolean isSideLit, boolean isAmbientOcclusion, TextureAtlasSprite particle, ImmutableMap<String, IBakedModel> bakedParts, IModelTransform combinedTransform, ItemOverrideList overrides, @Nullable String particleParent) {
            super(isGui3d, isSideLit, isAmbientOcclusion, particle, bakedParts, combinedTransform, overrides);
            this.bakedParts = bakedParts;
            this.particleParent = particleParent;
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            if (extraData instanceof CompositeModel.CompositeModelData) {
                return super.getQuads(state, side, rand, extraData);
            }
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            for (Map.Entry entry : this.bakedParts.entrySet()) {
                quads.addAll(((IBakedModel)entry.getValue()).getQuads(state, side, rand, extraData));
            }
            return quads;
        }

        @Nonnull
        @Deprecated
        public TextureAtlasSprite func_177554_e() {
            if (this.particleParent == null) {
                return super.func_177554_e();
            }
            return ((IBakedModel)this.bakedParts.get((Object)this.particleParent)).func_177554_e();
        }

        @Nonnull
        public TextureAtlasSprite getParticleTexture(@Nonnull IModelData extraData) {
            if (this.particleParent == null) {
                return super.getParticleTexture(extraData);
            }
            return ((IBakedModel)this.bakedParts.get((Object)this.particleParent)).getParticleTexture(extraData);
        }
    }

    public static class Geometry
    implements IMultipartModelGeometry<Geometry> {
        private final ImmutableMap<String, Submodel> parts;
        private final String particlePart;

        Geometry(ImmutableMap<String, Submodel> parts, @Nullable String particlePart) {
            this.parts = parts;
            this.particlePart = particlePart;
        }

        public Collection<? extends IModelGeometryPart> getParts() {
            return this.parts.values();
        }

        public Optional<? extends IModelGeometryPart> getPart(String name) {
            return Optional.ofNullable(this.parts.get((Object)name));
        }

        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
            RenderMaterial particleLocation = owner.resolveTexture("particle");
            TextureAtlasSprite particle = spriteGetter.apply(particleLocation);
            ImmutableMap.Builder bakedParts = ImmutableMap.builder();
            for (Map.Entry part : this.parts.entrySet()) {
                Submodel submodel = (Submodel)part.getValue();
                if (!owner.getPartVisibility((IModelGeometryPart)submodel)) continue;
                bakedParts.put(part.getKey(), (Object)submodel.bakeModel(bakery, spriteGetter, modelTransform, modelLocation));
            }
            return new BakedModel(owner.isShadedInGui(), owner.isSideLit(), owner.useSmoothLighting(), particle, (ImmutableMap<String, IBakedModel>)bakedParts.build(), owner.getCombinedTransform(), overrides, this.particlePart);
        }

        public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            HashSet<RenderMaterial> textures = new HashSet<RenderMaterial>();
            for (Submodel part : this.parts.values()) {
                textures.addAll(part.getTextures(owner, modelGetter, missingTextureErrors));
            }
            return textures;
        }
    }
}

