/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.fluid;

import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.fluid.IInfinityFluid;
import com.infinityraider.infinitylib.render.fluid.IFluidRenderer;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.lang.reflect.Field;
import java.util.Arrays;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.FluidBlockRenderer;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
public class InfFluidRenderer
extends FluidBlockRenderer {
    private final FluidBlockRenderer previous;

    private InfFluidRenderer(FluidBlockRenderer previous) {
        this.previous = previous;
    }

    public boolean func_228796_a_(IBlockDisplayReader world, BlockPos pos, IVertexBuilder builder, FluidState state) {
        IFluidRenderer renderer;
        if (state.func_206886_c() instanceof IInfinityFluid && (renderer = ((IInfinityFluid)state.func_206886_c()).getRenderer()) != null) {
            renderer.render(world, pos, builder, state);
            return true;
        }
        return this.previous.func_228796_a_(world, pos, builder, state);
    }

    public static void init() {
        InfinityLib.instance.getLogger().info("Trying to inject Fluid Renderer", new Object[0]);
        Arrays.stream(BlockRendererDispatcher.class.getDeclaredFields()).filter(field -> field.getType().isAssignableFrom(FluidBlockRenderer.class)).findAny().map(field -> {
            try {
                field.setAccessible(true);
                Field modifiers = Field.class.getDeclaredField("modifiers");
                modifiers.setAccessible(true);
                modifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                FluidBlockRenderer previous = (FluidBlockRenderer)field.get(Minecraft.func_71410_x().func_175602_ab());
                InfFluidRenderer renderer = new InfFluidRenderer(previous);
                field.set(Minecraft.func_71410_x().func_175602_ab(), (Object)renderer);
                InfinityLib.instance.getLogger().info("Successfully injected fluid renderer", new Object[0]);
            }
            catch (Exception e) {
                InfinityLib.instance.getLogger().info("Fluid Renderer injection failed", new Object[0]);
                e.printStackTrace();
            }
            return true;
        }).orElseGet(() -> {
            InfinityLib.instance.getLogger().info("No Fluid Renderer object found, very strange", new Object[0]);
            return false;
        });
    }
}

