/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.proxy;

import com.infinityraider.infinitylib.InfinityMod;
import com.infinityraider.infinitylib.block.IInfinityBlock;
import com.infinityraider.infinitylib.block.tile.IInfinityTileEntityType;
import com.infinityraider.infinitylib.config.Config;
import com.infinityraider.infinitylib.container.IInfinityContainerType;
import com.infinityraider.infinitylib.crafting.IInfIngredientSerializer;
import com.infinityraider.infinitylib.crafting.IInfRecipeSerializer;
import com.infinityraider.infinitylib.crafting.RecipeSerializers;
import com.infinityraider.infinitylib.effect.IInfinityEffect;
import com.infinityraider.infinitylib.enchantment.EnchantmentBase;
import com.infinityraider.infinitylib.enchantment.IInfinityEnchantment;
import com.infinityraider.infinitylib.entity.AmbientSpawnHandler;
import com.infinityraider.infinitylib.entity.IInfinityEntityType;
import com.infinityraider.infinitylib.entity.IInfinityLivingEntityType;
import com.infinityraider.infinitylib.fluid.IInfinityFluid;
import com.infinityraider.infinitylib.item.IInfinityItem;
import com.infinityraider.infinitylib.loot.IInfLootModifierSerializer;
import com.infinityraider.infinitylib.modules.Module;
import com.infinityraider.infinitylib.particle.IInfinityParticleType;
import com.infinityraider.infinitylib.proxy.base.IProxyBase;
import com.infinityraider.infinitylib.sound.IInfinitySoundEvent;
import com.infinityraider.infinitylib.utility.IInfinityRegistrable;
import com.infinityraider.infinitylib.utility.ReflectionHelper;
import com.infinityraider.infinitylib.world.IInfStructure;
import com.infinityraider.infinitylib.world.StructureRegistry;
import com.mojang.brigadier.StringReader;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface IProxy
extends IProxyBase<Config> {
    @Override
    default public Function<ForgeConfigSpec.Builder, Config> getConfigConstructor() {
        return Config.Common::new;
    }

    @Override
    default public void registerEventHandlers() {
        Module.getActiveModules().forEach(module -> module.getCommonEventHandlers().forEach(this::registerEventHandler));
        this.registerEventHandler(AmbientSpawnHandler.getInstance());
    }

    @Override
    default public void registerCapabilities() {
        Module.getActiveModules().forEach(module -> module.getCapabilities().forEach(this::registerCapability));
    }

    @Override
    default public void activateRequiredModules() {
    }

    @Override
    default public void onCommonSetupEvent(FMLCommonSetupEvent event) {
        Module.getActiveModules().forEach(Module::init);
        RecipeSerializers.getInstance().registerSerializers();
    }

    @Override
    default public void onServerAboutToStartEvent(FMLServerAboutToStartEvent event) {
        StructureRegistry.getInstance().injectStructures(event.getServer().func_244267_aX());
    }

    default public void forceClientRenderUpdate(BlockPos pos) {
    }

    default public void registerRegistrables(InfinityMod<?, ?> mod) {
        this.registerBlocks(mod);
        this.registerTiles(mod);
        this.registerItems(mod);
        this.registerFluids(mod);
        this.registerEnchantments(mod);
        this.registerEntities(mod);
        this.registerSounds(mod);
        this.registerParticles(mod);
        this.registerEffects(mod);
        this.registerContainers(mod);
        this.registerRecipeSerializers(mod);
        this.registerLootModifiers(mod);
        this.registerStructures(mod);
    }

    default public void registerBlocks(InfinityMod<?, ?> mod) {
        this.registerObjects(mod, mod.getModBlockRegistry(), Classes.BLOCK, ForgeRegistries.BLOCKS);
    }

    default public void registerTiles(InfinityMod<?, ?> mod) {
        this.registerObjects(mod, mod.getModTileRegistry(), Classes.TILE_ENTITY_TYPE, ForgeRegistries.TILE_ENTITIES);
    }

    default public void registerItems(InfinityMod<?, ?> mod) {
        this.registerObjects(mod, mod.getModItemRegistry(), Classes.ITEM, ForgeRegistries.ITEMS);
    }

    default public void registerFluids(InfinityMod<?, ?> mod) {
        this.registerObjects(mod, mod.getModFluidRegistry(), Classes.FLUID, ForgeRegistries.FLUIDS);
    }

    default public void registerEnchantments(InfinityMod<?, ?> mod) {
        this.registerObjects(mod, mod.getModEnchantmentRegistry(), Classes.ENCHANTMENT, ForgeRegistries.ENCHANTMENTS, enchant -> {
            if (enchant instanceof EnchantmentBase) {
                ((EnchantmentBase)enchant).setDisplayName("enchantment." + mod.getModId() + "." + enchant.getInternalName());
            }
        });
    }

    default public void registerEntities(InfinityMod<?, ?> mod) {
        DeferredRegister itemRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)mod.getModId());
        this.registerObjects(mod, mod.getModEntityRegistry(), Classes.ENTITY_TYPE, ForgeRegistries.ENTITIES, entityType -> {
            if (entityType instanceof IInfinityLivingEntityType) {
                IInfinityLivingEntityType livingEntityType = (IInfinityLivingEntityType)entityType;
                GlobalEntityTypeAttributes.put(livingEntityType.cast(), (AttributeModifierMap)livingEntityType.createCustomAttributes());
                livingEntityType.getSpawnEggData().ifPresent(data -> {
                    Item.Properties properties = new Item.Properties();
                    ItemGroup tab = data.tab();
                    if (tab != null) {
                        properties = properties.func_200916_a(tab);
                    }
                    SpawnEggItem egg = new SpawnEggItem(livingEntityType.cast(), data.primaryColor(), data.secondaryColor(), properties);
                    itemRegister.register(livingEntityType.getInternalName() + "_spawn_egg", () -> egg);
                });
                livingEntityType.getSpawnRules().forEach(rule -> AmbientSpawnHandler.getInstance().registerSpawnRule(livingEntityType.cast(), (IInfinityLivingEntityType.SpawnRule)rule));
            }
        });
        itemRegister.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    default public void registerSounds(InfinityMod<?, ?> mod) {
        this.registerObjects(mod, mod.getModSoundRegistry(), Classes.SOUND_EVENT, ForgeRegistries.SOUND_EVENTS);
    }

    default public void registerParticles(InfinityMod<?, ?> mod) {
        this.registerObjects(mod, mod.getModParticleRegistry(), Classes.PARTICLE_TYPE, ForgeRegistries.PARTICLE_TYPES, type -> this.onParticleRegistration((IInfinityParticleType)type));
    }

    default public <T extends IParticleData> void onParticleRegistration(IInfinityParticleType<T> particleType) {
    }

    default public void registerEffects(InfinityMod<?, ?> mod) {
        this.registerObjects(mod, mod.getModEffectRegistry(), Classes.EFFECT, ForgeRegistries.POTIONS);
    }

    default public void registerContainers(InfinityMod<?, ?> mod) {
        this.registerObjects(mod, mod.getModContainerRegistry(), Classes.CONTAINER_TYPE, ForgeRegistries.CONTAINERS, containerType -> {
            if (containerType instanceof IInfinityContainerType) {
                this.registerGuiContainer((IInfinityContainerType)containerType);
            }
        });
    }

    default public void registerRecipeSerializers(InfinityMod<?, ?> mod) {
        this.registerObjects(mod, mod.getModRecipeSerializerRegistry(), Classes.RECIPE_SERIALIZER, ForgeRegistries.RECIPE_SERIALIZERS, recipe -> {
            if (recipe instanceof IInfRecipeSerializer) {
                ((IInfRecipeSerializer)recipe).getIngredientSerializers().forEach(serializer -> RecipeSerializers.getInstance().registerSerializer((IInfIngredientSerializer<?>)serializer));
            }
        });
        if (mod.getModRecipeSerializerRegistry() != null) {
            ReflectionHelper.forEachValueIn(mod.getModRecipeSerializerRegistry(), IInfIngredientSerializer.class, serializer -> RecipeSerializers.getInstance().registerSerializer((IInfIngredientSerializer<?>)serializer));
        }
    }

    default public void registerLootModifiers(InfinityMod<?, ?> mod) {
        this.registerObjects(mod, mod.getModLootModifierSerializerRegistry(), Classes.LOOT_MODIFIER, ForgeRegistries.LOOT_MODIFIER_SERIALIZERS);
    }

    default public void registerStructures(InfinityMod<?, ?> mod) {
        Object registry = mod.getStructureRegistry();
        if (registry != null) {
            ReflectionHelper.forEachValueIn(registry, IInfStructure.class, structure -> {
                if (structure != null) {
                    StructureRegistry.getInstance().registerStructure((IInfStructure)structure);
                }
            });
        }
    }

    default public void registerGuiContainer(IInfinityContainerType containerType) {
    }

    default public <T extends IForgeRegistryEntry<T>> void registerObjects(InfinityMod<?, ?> mod, Object modRegistry, Class<? extends IInfinityRegistrable<T>> clazz, IForgeRegistry<T> targetRegistry) {
        this.registerObjects(mod, modRegistry, clazz, targetRegistry, obj -> {});
    }

    default public <T extends IForgeRegistryEntry<T>> void registerObjects(InfinityMod<?, ?> mod, Object modRegistry, Class<? extends IInfinityRegistrable<T>> clazz, IForgeRegistry<T> registry, Consumer<IInfinityRegistrable<T>> tasks) {
        if (modRegistry != null) {
            DeferredRegister register = DeferredRegister.create(registry, (String)mod.getModId());
            ReflectionHelper.forEachValueIn(modRegistry, clazz, object -> this.registerObject(mod, (IInfinityRegistrable)object, (DeferredRegister)register, tasks));
            register.register(FMLJavaModLoadingContext.get().getModEventBus());
        }
    }

    default public <T extends IForgeRegistryEntry<T>> void registerObject(InfinityMod<?, ?> mod, IInfinityRegistrable<T> object, DeferredRegister<T> register, Consumer<IInfinityRegistrable<T>> tasks) {
        if (object.isEnabled()) {
            mod.getLogger().debug(" - Registering: " + object.getInternalName(), new Object[0]);
            register.register(object.getInternalName(), object::cast);
            tasks.accept(object);
        }
    }

    default public void registerRenderers(InfinityMod<?, ?> mod) {
    }

    public static final class Classes {
        private static final Class<? extends IInfinityRegistrable<Block>> BLOCK = IInfinityBlock.class;
        private static final Class<? extends IInfinityRegistrable<TileEntityType<?>>> TILE_ENTITY_TYPE = IInfinityTileEntityType.class;
        private static final Class<? extends IInfinityRegistrable<Item>> ITEM = IInfinityItem.class;
        private static final Class<? extends IInfinityRegistrable<Fluid>> FLUID = IInfinityFluid.class;
        private static final Class<? extends IInfinityRegistrable<Enchantment>> ENCHANTMENT = IInfinityEnchantment.class;
        private static final Class<? extends IInfinityRegistrable<EntityType<?>>> ENTITY_TYPE = IInfinityEntityType.class;
        private static final Class<? extends IInfinityRegistrable<SoundEvent>> SOUND_EVENT = IInfinitySoundEvent.class;
        private static final Class<? extends IInfinityRegistrable<ParticleType<?>>> PARTICLE_TYPE;
        private static final Class<? extends IInfinityRegistrable<Effect>> EFFECT;
        private static final Class<? extends IInfinityRegistrable<ContainerType<?>>> CONTAINER_TYPE;
        private static final Class<? extends IInfinityRegistrable<IRecipeSerializer<?>>> RECIPE_SERIALIZER;
        private static final Class<? extends IInfinityRegistrable<GlobalLootModifierSerializer<?>>> LOOT_MODIFIER;

        private Classes() {
        }

        static {
            EFFECT = IInfinityEffect.class;
            CONTAINER_TYPE = IInfinityContainerType.class;
            RECIPE_SERIALIZER = IInfRecipeSerializer.class;
            LOOT_MODIFIER = IInfLootModifierSerializer.class;
            PARTICLE_TYPE = new IInfinityParticleType<IParticleData>(){

                @Override
                public boolean isEnabled() {
                    return false;
                }

                @Override
                @Nonnull
                public String getInternalName() {
                    return "";
                }

                @Override
                public IParticleData deserializeData(@Nonnull StringReader reader) {
                    return null;
                }

                @Override
                public IParticleData readData(@Nonnull PacketBuffer buffer) {
                    return null;
                }

                @Override
                @Nonnull
                public IInfinityParticleType.ParticleFactorySupplier<IParticleData> particleFactorySupplier() {
                    return () -> null;
                }
            }.getClass().getInterfaces()[0];
        }
    }
}

