/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.modules.playeranimations;

import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.modules.playeranimations.IAnimatablePlayerModel;
import java.lang.reflect.Field;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelHelper;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelPlayerCustomized<T extends LivingEntity>
extends PlayerModel<T>
implements IAnimatablePlayerModel {
    private static final ModelPlayerCustomized<PlayerEntity> MODEL_MAIN = new ModelPlayerCustomized(0.0f, false);
    private static final ModelPlayerCustomized<PlayerEntity> MODEL_SLIM = new ModelPlayerCustomized(0.0f, true);
    private float swingProgressLeft;
    private float swingProgressRight;
    private boolean doArmWobble;

    private ModelPlayerCustomized(float modelSize, boolean smallArmsIn) {
        super(modelSize, smallArmsIn);
    }

    @Override
    public void setSwingProgress(float left, float right) {
        this.swingProgressLeft = left;
        this.swingProgressRight = right;
    }

    @Override
    public void setDoArmWobble(boolean status) {
        this.doArmWobble = status;
    }

    public void func_225597_a_(@Nonnull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean primary_swing;
        super.func_225597_a_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        boolean isElytraFlying = entity.func_184599_cB() > 4;
        boolean isSwimming = entity.func_213314_bj();
        this.field_78116_c.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.field_78116_c.field_78795_f = isElytraFlying ? -0.7853982f : (this.field_205061_a > 0.0f ? (isSwimming ? this.func_205060_a(this.field_205061_a, this.field_78116_c.field_78795_f, -0.7853982f) : this.func_205060_a(this.field_205061_a, this.field_78116_c.field_78795_f, headPitch * ((float)Math.PI / 180))) : headPitch * ((float)Math.PI / 180));
        this.field_78115_e.field_78796_g = 0.0f;
        this.field_178723_h.field_78798_e = 0.0f;
        this.field_178723_h.field_78800_c = -5.0f;
        this.field_178724_i.field_78798_e = 0.0f;
        this.field_178724_i.field_78800_c = 5.0f;
        float f = 1.0f;
        if (isElytraFlying) {
            f = (float)entity.func_213322_ci().func_189985_c();
            f /= 0.2f;
            f = f * f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.field_178723_h.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f / f;
        this.field_178724_i.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f / f;
        this.field_178723_h.field_78808_h = 0.0f;
        this.field_178724_i.field_78808_h = 0.0f;
        this.field_178721_j.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount / f;
        this.field_178722_k.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount / f;
        this.field_178721_j.field_78796_g = 0.0f;
        this.field_178722_k.field_78796_g = 0.0f;
        this.field_178721_j.field_78808_h = 0.0f;
        this.field_178722_k.field_78808_h = 0.0f;
        if (this.field_217113_d) {
            this.field_178723_h.field_78795_f += -0.62831855f;
            this.field_178724_i.field_78795_f += -0.62831855f;
            this.field_178721_j.field_78795_f = -1.4137167f;
            this.field_178721_j.field_78796_g = 0.31415927f;
            this.field_178721_j.field_78808_h = 0.07853982f;
            this.field_178722_k.field_78795_f = -1.4137167f;
            this.field_178722_k.field_78796_g = -0.31415927f;
            this.field_178722_k.field_78808_h = -0.07853982f;
        }
        this.field_178723_h.field_78796_g = 0.0f;
        this.field_178723_h.field_78808_h = 0.0f;
        this.field_178723_h.field_78796_g = 0.0f;
        this.field_178724_i.field_78796_g = 0.0f;
        boolean primary_right = entity.func_184591_cq() == HandSide.RIGHT;
        boolean bl = primary_swing = primary_right ? this.field_187075_l.func_241657_a_() : this.field_187076_m.func_241657_a_();
        if (primary_right != primary_swing) {
            this.handleLeftArmPose(entity);
            this.handleRightArmPose(entity);
        } else {
            this.handleRightArmPose(entity);
            this.handleLeftArmPose(entity);
        }
        this.handleSwingProcess(entity, ageInTicks);
        if (this.field_228270_o_) {
            this.field_78115_e.field_78795_f = 0.5f;
            this.field_178723_h.field_78795_f += 0.4f;
            this.field_178724_i.field_78795_f += 0.4f;
            this.field_178721_j.field_78798_e = 4.0f;
            this.field_178722_k.field_78798_e = 4.0f;
            this.field_178721_j.field_78797_d = 12.2f;
            this.field_178722_k.field_78797_d = 12.2f;
            this.field_78116_c.field_78797_d = 4.2f;
            this.field_78115_e.field_78797_d = 3.2f;
            this.field_178724_i.field_78797_d = 5.2f;
            this.field_178723_h.field_78797_d = 5.2f;
        } else {
            this.field_78115_e.field_78795_f = 0.0f;
            this.field_178721_j.field_78798_e = 0.1f;
            this.field_178722_k.field_78798_e = 0.1f;
            this.field_178721_j.field_78797_d = 12.0f;
            this.field_178722_k.field_78797_d = 12.0f;
            this.field_78116_c.field_78797_d = 0.0f;
            this.field_78115_e.field_78797_d = 0.0f;
            this.field_178724_i.field_78797_d = 2.0f;
            this.field_178723_h.field_78797_d = 2.0f;
        }
        if (this.doArmWobble) {
            ModelHelper.func_239101_a_((ModelRenderer)this.field_178723_h, (ModelRenderer)this.field_178724_i, (float)ageInTicks);
        }
        if (this.field_205061_a > 0.0f) {
            float f3;
            float f1 = limbSwing % 26.0f;
            HandSide handside = this.func_217147_a((LivingEntity)entity);
            float f2 = handside == HandSide.RIGHT && this.field_217112_c > 0.0f ? 0.0f : this.field_205061_a;
            float f4 = f3 = handside == HandSide.LEFT && this.field_217112_c > 0.0f ? 0.0f : this.field_205061_a;
            if (f1 < 14.0f) {
                this.field_178724_i.field_78795_f = this.func_205060_a(f3, this.field_178724_i.field_78795_f, 0.0f);
                this.field_178723_h.field_78795_f = MathHelper.func_219799_g((float)f2, (float)this.field_178723_h.field_78795_f, (float)0.0f);
                this.field_178724_i.field_78796_g = this.func_205060_a(f3, this.field_178724_i.field_78796_g, (float)Math.PI);
                this.field_178723_h.field_78796_g = MathHelper.func_219799_g((float)f2, (float)this.field_178723_h.field_78796_g, (float)((float)Math.PI));
                this.field_178724_i.field_78808_h = this.func_205060_a(f3, this.field_178724_i.field_78808_h, (float)Math.PI + 1.8707964f * this.getArmAngleSq(f1) / this.getArmAngleSq(14.0f));
                this.field_178723_h.field_78808_h = MathHelper.func_219799_g((float)f2, (float)this.field_178723_h.field_78808_h, (float)((float)Math.PI - 1.8707964f * this.getArmAngleSq(f1) / this.getArmAngleSq(14.0f)));
            } else if (f1 >= 14.0f && f1 < 22.0f) {
                float f6 = (f1 - 14.0f) / 8.0f;
                this.field_178724_i.field_78795_f = this.func_205060_a(f3, this.field_178724_i.field_78795_f, 1.5707964f * f6);
                this.field_178723_h.field_78795_f = MathHelper.func_219799_g((float)f2, (float)this.field_178723_h.field_78795_f, (float)(1.5707964f * f6));
                this.field_178724_i.field_78796_g = this.func_205060_a(f3, this.field_178724_i.field_78796_g, (float)Math.PI);
                this.field_178723_h.field_78796_g = MathHelper.func_219799_g((float)f2, (float)this.field_178723_h.field_78796_g, (float)((float)Math.PI));
                this.field_178724_i.field_78808_h = this.func_205060_a(f3, this.field_178724_i.field_78808_h, 5.012389f - 1.8707964f * f6);
                this.field_178723_h.field_78808_h = MathHelper.func_219799_g((float)f2, (float)this.field_178723_h.field_78808_h, (float)(1.2707963f + 1.8707964f * f6));
            } else if (f1 >= 22.0f && f1 < 26.0f) {
                float f42 = (f1 - 22.0f) / 4.0f;
                this.field_178724_i.field_78795_f = this.func_205060_a(f3, this.field_178724_i.field_78795_f, 1.5707964f - 1.5707964f * f42);
                this.field_178723_h.field_78795_f = MathHelper.func_219799_g((float)f2, (float)this.field_178723_h.field_78795_f, (float)(1.5707964f - 1.5707964f * f42));
                this.field_178724_i.field_78796_g = this.func_205060_a(f3, this.field_178724_i.field_78796_g, (float)Math.PI);
                this.field_178723_h.field_78796_g = MathHelper.func_219799_g((float)f2, (float)this.field_178723_h.field_78796_g, (float)((float)Math.PI));
                this.field_178724_i.field_78808_h = this.func_205060_a(f3, this.field_178724_i.field_78808_h, (float)Math.PI);
                this.field_178723_h.field_78808_h = MathHelper.func_219799_g((float)f2, (float)this.field_178723_h.field_78808_h, (float)((float)Math.PI));
            }
            this.field_178722_k.field_78795_f = MathHelper.func_219799_g((float)this.field_205061_a, (float)this.field_178722_k.field_78795_f, (float)(0.3f * MathHelper.func_76134_b((float)(limbSwing * 0.33333334f + (float)Math.PI))));
            this.field_178721_j.field_78795_f = MathHelper.func_219799_g((float)this.field_205061_a, (float)this.field_178721_j.field_78795_f, (float)(0.3f * MathHelper.func_76134_b((float)(limbSwing * 0.33333334f))));
        }
        this.field_178720_f.func_217177_a(this.field_78116_c);
        this.field_178733_c.func_217177_a(this.field_178722_k);
        this.field_178731_d.func_217177_a(this.field_178721_j);
        this.field_178734_a.func_217177_a(this.field_178724_i);
        this.field_178732_b.func_217177_a(this.field_178723_h);
        this.field_178730_v.func_217177_a(this.field_78115_e);
    }

    private float getArmAngleSq(float limbSwing) {
        return -65.0f * limbSwing + limbSwing * limbSwing;
    }

    private void handleRightArmPose(T entity) {
        switch (this.field_187076_m) {
            case EMPTY: {
                this.field_178723_h.field_78796_g = 0.0f;
                break;
            }
            case BLOCK: {
                this.field_178723_h.field_78795_f = this.field_178723_h.field_78795_f * 0.5f - 0.9424779f;
                this.field_178723_h.field_78796_g = -0.5235988f;
                break;
            }
            case ITEM: {
                this.field_178723_h.field_78795_f = this.field_178723_h.field_78795_f * 0.5f - 0.31415927f;
                this.field_178723_h.field_78796_g = 0.0f;
                break;
            }
            case THROW_SPEAR: {
                this.field_178723_h.field_78795_f = this.field_178723_h.field_78795_f * 0.5f - (float)Math.PI;
                this.field_178723_h.field_78796_g = 0.0f;
                break;
            }
            case BOW_AND_ARROW: {
                this.field_178723_h.field_78796_g = -0.1f + this.field_78116_c.field_78796_g;
                this.field_178724_i.field_78796_g = 0.1f + this.field_78116_c.field_78796_g + 0.4f;
                this.field_178723_h.field_78795_f = -1.5707964f + this.field_78116_c.field_78795_f;
                this.field_178724_i.field_78795_f = -1.5707964f + this.field_78116_c.field_78795_f;
                break;
            }
            case CROSSBOW_CHARGE: {
                ModelHelper.func_239102_a_((ModelRenderer)this.field_178723_h, (ModelRenderer)this.field_178724_i, entity, (boolean)true);
                break;
            }
            case CROSSBOW_HOLD: {
                ModelHelper.func_239104_a_((ModelRenderer)this.field_178723_h, (ModelRenderer)this.field_178724_i, (ModelRenderer)this.field_78116_c, (boolean)true);
            }
        }
    }

    private void handleLeftArmPose(T entity) {
        switch (this.field_187075_l) {
            case EMPTY: {
                this.field_178724_i.field_78796_g = 0.0f;
                break;
            }
            case BLOCK: {
                this.field_178724_i.field_78795_f = this.field_178724_i.field_78795_f * 0.5f - 0.9424779f;
                this.field_178724_i.field_78796_g = 0.5235988f;
                break;
            }
            case ITEM: {
                this.field_178724_i.field_78795_f = this.field_178724_i.field_78795_f * 0.5f - 0.31415927f;
                this.field_178724_i.field_78796_g = 0.0f;
                break;
            }
            case THROW_SPEAR: {
                this.field_178724_i.field_78795_f = this.field_178724_i.field_78795_f * 0.5f - (float)Math.PI;
                this.field_178724_i.field_78796_g = 0.0f;
                break;
            }
            case BOW_AND_ARROW: {
                this.field_178723_h.field_78796_g = -0.1f + this.field_78116_c.field_78796_g - 0.4f;
                this.field_178724_i.field_78796_g = 0.1f + this.field_78116_c.field_78796_g;
                this.field_178723_h.field_78795_f = -1.5707964f + this.field_78116_c.field_78795_f;
                this.field_178724_i.field_78795_f = -1.5707964f + this.field_78116_c.field_78795_f;
                break;
            }
            case CROSSBOW_CHARGE: {
                ModelHelper.func_239102_a_((ModelRenderer)this.field_178723_h, (ModelRenderer)this.field_178724_i, entity, (boolean)false);
                break;
            }
            case CROSSBOW_HOLD: {
                ModelHelper.func_239104_a_((ModelRenderer)this.field_178723_h, (ModelRenderer)this.field_178724_i, (ModelRenderer)this.field_78116_c, (boolean)false);
            }
        }
    }

    private void handleSwingProcess(T entity, float ageInTicks) {
        if (this.swingProgressLeft > 0.0f || this.swingProgressRight > 0.0f) {
            if (this.swingProgressLeft > 0.0f) {
                HandSide handSide = HandSide.LEFT;
                ModelRenderer modelrenderer = this.func_187074_a(handSide);
                float f = this.swingProgressLeft;
                this.field_78115_e.field_78796_g = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)f) * ((float)Math.PI * 2))) * 0.2f;
                this.field_78115_e.field_78796_g *= -1.0f;
                this.field_178723_h.field_78798_e = MathHelper.func_76126_a((float)this.field_78115_e.field_78796_g) * 5.0f;
                this.field_178723_h.field_78800_c = -MathHelper.func_76134_b((float)this.field_78115_e.field_78796_g) * 5.0f;
                this.field_178724_i.field_78798_e = -MathHelper.func_76126_a((float)this.field_78115_e.field_78796_g) * 5.0f;
                this.field_178724_i.field_78800_c = MathHelper.func_76134_b((float)this.field_78115_e.field_78796_g) * 5.0f;
                this.field_178723_h.field_78796_g += this.field_78115_e.field_78796_g;
                this.field_178724_i.field_78796_g += this.field_78115_e.field_78796_g;
                this.field_178724_i.field_78795_f += this.field_78115_e.field_78796_g;
                f = 1.0f - this.swingProgressLeft;
                f *= f;
                f *= f;
                f = 1.0f - f;
                float f1 = MathHelper.func_76126_a((float)(f * (float)Math.PI));
                float f2 = MathHelper.func_76126_a((float)(this.swingProgressLeft * (float)Math.PI)) * -(this.field_78116_c.field_78795_f - 0.7f) * 0.75f;
                modelrenderer.field_78795_f = (float)((double)modelrenderer.field_78795_f - ((double)f1 * 1.2 + (double)f2));
                modelrenderer.field_78796_g += this.field_78115_e.field_78796_g * 2.0f;
                modelrenderer.field_78808_h += MathHelper.func_76126_a((float)(this.swingProgressLeft * (float)Math.PI)) * -0.4f;
            } else {
                HandSide handSide = HandSide.RIGHT;
                ModelRenderer modelrenderer = this.func_187074_a(handSide);
                float f = this.swingProgressRight;
                this.field_78115_e.field_78796_g = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)f) * ((float)Math.PI * 2))) * 0.2f;
                this.field_178723_h.field_78798_e = MathHelper.func_76126_a((float)this.field_78115_e.field_78796_g) * 5.0f;
                this.field_178723_h.field_78800_c = -MathHelper.func_76134_b((float)this.field_78115_e.field_78796_g) * 5.0f;
                this.field_178724_i.field_78798_e = -MathHelper.func_76126_a((float)this.field_78115_e.field_78796_g) * 5.0f;
                this.field_178724_i.field_78800_c = MathHelper.func_76134_b((float)this.field_78115_e.field_78796_g) * 5.0f;
                this.field_178723_h.field_78796_g += this.field_78115_e.field_78796_g;
                this.field_178724_i.field_78796_g += this.field_78115_e.field_78796_g;
                this.field_178724_i.field_78795_f += this.field_78115_e.field_78796_g;
                f = 1.0f - this.swingProgressRight;
                f *= f;
                f *= f;
                f = 1.0f - f;
                float f1 = MathHelper.func_76126_a((float)(f * (float)Math.PI));
                float f2 = MathHelper.func_76126_a((float)(this.swingProgressRight * (float)Math.PI)) * -(this.field_78116_c.field_78795_f - 0.7f) * 0.75f;
                modelrenderer.field_78795_f = (float)((double)modelrenderer.field_78795_f - ((double)f1 * 1.2 + (double)f2));
                modelrenderer.field_78796_g += this.field_78115_e.field_78796_g * 2.0f;
                modelrenderer.field_78808_h += MathHelper.func_76126_a((float)(this.swingProgressRight * (float)Math.PI)) * -0.4f;
            }
        } else if (this.field_217112_c > 0.0f) {
            HandSide handSide = this.func_217147_a((LivingEntity)entity);
            ModelRenderer modelrenderer = this.func_187074_a(handSide);
            float f = this.field_217112_c;
            this.field_78115_e.field_78796_g = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)f) * ((float)Math.PI * 2))) * 0.2f;
            if (handSide == HandSide.LEFT) {
                this.field_78115_e.field_78796_g *= -1.0f;
            }
            this.field_178723_h.field_78798_e = MathHelper.func_76126_a((float)this.field_78115_e.field_78796_g) * 5.0f;
            this.field_178723_h.field_78800_c = -MathHelper.func_76134_b((float)this.field_78115_e.field_78796_g) * 5.0f;
            this.field_178724_i.field_78798_e = -MathHelper.func_76126_a((float)this.field_78115_e.field_78796_g) * 5.0f;
            this.field_178724_i.field_78800_c = MathHelper.func_76134_b((float)this.field_78115_e.field_78796_g) * 5.0f;
            this.field_178723_h.field_78796_g += this.field_78115_e.field_78796_g;
            this.field_178724_i.field_78796_g += this.field_78115_e.field_78796_g;
            this.field_178724_i.field_78795_f += this.field_78115_e.field_78796_g;
            f = 1.0f - this.field_217112_c;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = MathHelper.func_76126_a((float)(f * (float)Math.PI));
            float f2 = MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI)) * -(this.field_78116_c.field_78795_f - 0.7f) * 0.75f;
            modelrenderer.field_78795_f = (float)((double)modelrenderer.field_78795_f - ((double)f1 * 1.2 + (double)f2));
            modelrenderer.field_78796_g += this.field_78115_e.field_78796_g * 2.0f;
            modelrenderer.field_78808_h += MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI)) * -0.4f;
        }
    }

    public static void replaceOldModel() {
        PlayerRenderer renderer = ModelPlayerCustomized.getOldRenderer("default");
        if (renderer == null) {
            InfinityLib.instance.getLogger().debug("Failed overriding left arm swing behaviour", new Object[0]);
            return;
        }
        PlayerModel oldModel = (PlayerModel)renderer.func_217764_d();
        if (oldModel instanceof ModelPlayerCustomized) {
            return;
        }
        ModelPlayerCustomized<PlayerEntity> newModel = null;
        for (Field field : LivingRenderer.class.getDeclaredFields()) {
            if (!Model.class.isAssignableFrom(field.getType())) continue;
            try {
                field.setAccessible(true);
                Object obj = field.get(renderer);
                if (obj != oldModel) continue;
                newModel = MODEL_MAIN;
                field.set(renderer, newModel);
                break;
            }
            catch (Exception e) {
                InfinityLib.instance.getLogger().printStackTrace(e);
            }
        }
        if (newModel != null) {
            ModelPlayerCustomized.replaceEntriesInRenderPlayer(renderer, newModel);
            ModelPlayerCustomized.replaceEntriesInRenderPlayer(ModelPlayerCustomized.getOldRenderer("slim"), MODEL_SLIM);
        }
    }

    private static PlayerRenderer getOldRenderer(String keyword) {
        EntityRendererManager manager = Minecraft.func_71410_x().func_175598_ae();
        Map skinMap = manager.getSkinMap();
        return (PlayerRenderer)skinMap.get(keyword);
    }

    private static void replaceEntriesInRenderPlayer(PlayerRenderer renderer, PlayerModel<?> newModel) {
        if (renderer == null) {
            return;
        }
        for (Field field : LivingRenderer.class.getDeclaredFields()) {
            if (!Model.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            try {
                field.set(renderer, newModel);
            }
            catch (IllegalAccessException e) {
                InfinityLib.instance.getLogger().printStackTrace(e);
            }
            break;
        }
    }
}

