/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.modules.dynamiccamera;

import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.entity.EntityTypeBase;
import com.infinityraider.infinitylib.modules.dynamiccamera.IDynamicCameraController;
import com.infinityraider.infinitylib.proxy.IProxy;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT)
public class DynamicCamera
extends Entity {
    private static final EntityType<DynamicCamera> TYPE = EntityTypeBase.entityTypeBuilder("infinity_dyn_camera", DynamicCamera.class, SpawnFactory.getInstance(), EntityClassification.MISC, EntitySize.func_220311_c((float)0.0625f, (float)0.0625f)).build();
    private static DynamicCamera INSTANCE;
    private Status status = Status.IDLE;
    private IDynamicCameraController controller;
    private Entity originalCamera;
    private Vector3d originalPosition;
    private Vector2f originalOrientation;
    private PointOfView originalPov;
    private int counter;
    private static final Function<DynamicCamera, Status> IDLE_TICK;
    private static final Function<DynamicCamera, Status> POSITIONING_TICK;
    private static final Function<DynamicCamera, Status> OBSERVING_TICK;
    private static final Function<DynamicCamera, Status> RETURNING_TICK;
    private static final Function<DynamicCamera, Status> FINISHED_TICK;

    @Nullable
    private static DynamicCamera getInstance() {
        if (INSTANCE == null && InfinityLib.instance.getClientWorld() != null) {
            INSTANCE = new DynamicCamera(InfinityLib.instance.getClientWorld());
        }
        return INSTANCE;
    }

    public static boolean startControllingCamera(IDynamicCameraController controller) {
        DynamicCamera camera = DynamicCamera.getInstance();
        if (camera != null) {
            return camera.startObserving(controller);
        }
        return false;
    }

    public static boolean stopControllingCamera() {
        DynamicCamera camera = DynamicCamera.getInstance();
        if (camera != null) {
            camera.stopObserving();
            return true;
        }
        return false;
    }

    public static boolean toggleCameraControl(IDynamicCameraController controller, boolean status) {
        if (DynamicCamera.isCameraActive()) {
            if (status) {
                return false;
            }
            if (DynamicCamera.getCameraController() == controller) {
                return DynamicCamera.stopControllingCamera();
            }
            return false;
        }
        return status && DynamicCamera.startControllingCamera(controller);
    }

    @Nullable
    public static IDynamicCameraController getCameraController() {
        DynamicCamera camera = DynamicCamera.getInstance();
        if (camera != null) {
            return camera.controller;
        }
        return null;
    }

    public static Status getCameraStatus() {
        DynamicCamera camera = DynamicCamera.getInstance();
        return camera == null ? Status.IDLE : camera.getStatus();
    }

    public static int getCameraAnimationFrame() {
        DynamicCamera camera = DynamicCamera.getInstance();
        return camera == null ? 0 : camera.counter;
    }

    public static void tickCamera() {
        DynamicCamera camera = DynamicCamera.getInstance();
        if (camera != null) {
            camera.func_70071_h_();
        }
    }

    public static void resetCamera() {
        INSTANCE = null;
    }

    public static boolean isCameraActive() {
        DynamicCamera camera = DynamicCamera.getInstance();
        return camera != null && camera.getStatus().isActive();
    }

    public static void onFieldOfViewUpdate(float fov) {
        DynamicCamera camera = DynamicCamera.getInstance();
        if (camera != null) {
            camera.onFieldOfViewChange(fov);
        }
    }

    public static boolean isCameraInPlayer(PlayerEntity player, float partialTick) {
        DynamicCamera camera;
        if (DynamicCamera.isCameraActive() && (camera = DynamicCamera.getInstance()) != null) {
            return player.func_184177_bl().func_72318_a(camera.getPosition(partialTick));
        }
        return false;
    }

    public DynamicCamera(World world) {
        this(TYPE, world);
    }

    public DynamicCamera(EntityType<DynamicCamera> type, World world) {
        super(type, world);
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void onFieldOfViewChange(float fov) {
        if (this.controller != null) {
            this.controller.onFieldOfViewChanged(fov);
        }
    }

    public boolean startObserving(IDynamicCameraController controller) {
        if (this.controller != null) {
            return false;
        }
        this.setStatus(Status.POSITIONING);
        this.controller = controller;
        this.originalCamera = ((IProxy)InfinityLib.instance.proxy()).getRenderViewEntity();
        Entity prevCamera = this.getOriginalRenderViewEntity();
        this.originalPosition = prevCamera.func_174824_e(1.0f);
        this.originalOrientation = new Vector2f(prevCamera.func_195050_f(1.0f), prevCamera.func_195046_g(1.0f));
        this.func_70080_a(this.originalPosition.func_82615_a(), this.originalPosition.func_82617_b(), this.originalPosition.func_82616_c(), this.originalOrientation.field_189982_i, this.originalOrientation.field_189983_j);
        this.status = Status.POSITIONING;
        this.originalPov = Minecraft.func_71410_x().field_71474_y.func_243230_g();
        Minecraft.func_71410_x().field_71474_y.func_243229_a(PointOfView.FIRST_PERSON);
        ((IProxy)InfinityLib.instance.proxy()).setRenderViewEntity(this);
        return true;
    }

    public void stopObserving() {
        if (this.controller != null) {
            this.controller.onObservationEnd();
        }
        if (this.getStatus().isActive()) {
            this.setStatus(Status.RETURNING);
        }
    }

    public boolean shouldContinueObserving() {
        return this.controller.shouldContinueObserving();
    }

    public Vector3d getOriginalPosition() {
        return this.originalPosition;
    }

    public Vector2f getOriginalOrientation() {
        return this.originalOrientation;
    }

    public Vector3d getTargetPosition() {
        return this.controller.getObserverPosition();
    }

    public Vector2f getTargetOrientation() {
        return this.controller.getObserverOrientation();
    }

    public Vector3d getReturnPosition() {
        return this.getOriginalRenderViewEntity().func_174824_e(1.0f);
    }

    public Vector2f getReturnOrientation() {
        Entity original = this.getOriginalRenderViewEntity();
        return new Vector2f(original.func_195050_f(1.0f), original.func_195046_g(1.0f));
    }

    protected Entity getOriginalRenderViewEntity() {
        return this.originalCamera == null ? InfinityLib.instance.getClientPlayer() : this.originalCamera;
    }

    public void setPositionAndRotation(Vector3d position, Vector2f orientation) {
        this.setPositionAndRotation(position, orientation.field_189982_i, orientation.field_189983_j);
    }

    public void setPositionAndRotation(Vector3d position, float pitch, float yaw) {
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        this.func_226288_n_(position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.field_70177_z = yaw;
        this.field_70125_A = pitch;
    }

    protected boolean moveIncrement(Vector3d startPos, Vector2f startOri, Vector3d endPos, Vector2f endOri) {
        int duration = this.getTransitionDuration();
        if (this.counter >= duration) {
            this.setPositionAndRotation(endPos, endOri);
            return true;
        }
        double ratioD = ((double)this.counter + 0.0) / (double)duration;
        float ratioF = ((float)this.counter + 0.0f) / (float)duration;
        float targetYaw = endOri.field_189983_j % 360.0f;
        float startYaw = startOri.field_189983_j % 360.0f;
        if (targetYaw - startYaw > 180.0f) {
            targetYaw -= 360.0f;
        } else if (targetYaw - startYaw < -180.0f) {
            startYaw -= 360.0f;
        }
        this.setPositionAndRotation(startPos.func_178787_e(endPos.func_178788_d(startPos).func_186678_a(ratioD)), startOri.field_189982_i + (endOri.field_189982_i - startOri.field_189982_i) * ratioF, startYaw + (targetYaw - startYaw) * ratioF);
        return false;
    }

    protected Vector3d getPosition(float partialTicks) {
        return new Vector3d(MathHelper.func_219803_d((double)partialTicks, (double)this.field_70169_q, (double)this.func_226277_ct_()), MathHelper.func_219803_d((double)partialTicks, (double)this.field_70167_r, (double)this.func_226278_cu_()), MathHelper.func_219803_d((double)partialTicks, (double)this.field_70166_s, (double)this.func_226281_cx_()));
    }

    protected int getTransitionDuration() {
        return this.controller.getTransitionDuration();
    }

    protected void holdPositionAndOrientation(Vector3d position, Vector2f orientation) {
        this.func_226288_n_(position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        this.field_70127_C = this.field_70125_A = orientation.field_189982_i;
        this.field_70126_B = this.field_70177_z = orientation.field_189983_j;
    }

    public void func_70071_h_() {
        this.func_70030_z();
    }

    public void func_70030_z() {
        if (this.controller == null) {
            if (this.status != Status.IDLE) {
                this.reset();
            }
            return;
        }
        this.setStatus(this.getStatus().tick(this));
    }

    public void reset() {
        this.status = Status.IDLE;
        if (this.controller != null) {
            this.controller = null;
        }
        ((IProxy)InfinityLib.instance.proxy()).setRenderViewEntity((Entity)InfinityLib.instance.getClientPlayer());
        if (this.originalPov != null) {
            Minecraft.func_71410_x().field_71474_y.func_243229_a(this.originalPov);
        }
        this.originalCamera = null;
        this.originalPosition = null;
        this.originalOrientation = null;
        this.originalPov = null;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(@Nonnull CompoundNBT compound) {
    }

    protected void func_213281_b(@Nonnull CompoundNBT compound) {
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    static /* synthetic */ Function access$100() {
        return IDLE_TICK;
    }

    static /* synthetic */ Function access$200() {
        return POSITIONING_TICK;
    }

    static /* synthetic */ Function access$300() {
        return OBSERVING_TICK;
    }

    static /* synthetic */ Function access$400() {
        return RETURNING_TICK;
    }

    static /* synthetic */ Function access$500() {
        return FINISHED_TICK;
    }

    static {
        IDLE_TICK = camera -> Status.IDLE;
        POSITIONING_TICK = camera -> {
            if (camera.counter <= 0) {
                camera.controller.onCameraActivated();
                camera.counter = 0;
            }
            ++camera.counter;
            if (camera.shouldContinueObserving()) {
                if (camera.moveIncrement(camera.getOriginalPosition(), camera.getOriginalOrientation(), camera.getTargetPosition(), camera.getTargetOrientation())) {
                    camera.controller.onObservationStart();
                    return Status.OBSERVING;
                }
                return Status.POSITIONING;
            }
            camera.counter = camera.getTransitionDuration() - camera.counter;
            return Status.RETURNING;
        };
        OBSERVING_TICK = camera -> {
            if (camera.shouldContinueObserving()) {
                if (camera.counter != 0) {
                    camera.counter = 0;
                }
                camera.holdPositionAndOrientation(camera.getTargetPosition(), camera.getTargetOrientation());
                return Status.OBSERVING;
            }
            camera.controller.onObservationEnd();
            return Status.RETURNING;
        };
        RETURNING_TICK = camera -> {
            if (camera.counter <= 0) {
                camera.counter = 0;
            }
            ++camera.counter;
            if (camera.moveIncrement(camera.getTargetPosition(), camera.getTargetOrientation(), camera.getReturnPosition(), camera.getReturnOrientation())) {
                return Status.FINISHED;
            }
            return Status.RETURNING;
        };
        FINISHED_TICK = camera -> {
            if (camera.counter != 0) {
                camera.counter = 0;
            }
            camera.controller.onCameraDeactivated();
            camera.reset();
            return Status.IDLE;
        };
    }

    public static class SpawnFactory
    implements EntityType.IFactory<DynamicCamera> {
        private static final SpawnFactory INSTANCE = new SpawnFactory();

        public static SpawnFactory getInstance() {
            return INSTANCE;
        }

        private SpawnFactory() {
        }

        @Nonnull
        public DynamicCamera create(@Nonnull EntityType<DynamicCamera> type, @Nonnull World world) {
            return new DynamicCamera(type, world);
        }
    }

    public static enum Status {
        IDLE(false, DynamicCamera.access$100()),
        POSITIONING(true, DynamicCamera.access$200()),
        OBSERVING(true, DynamicCamera.access$300()),
        RETURNING(true, DynamicCamera.access$400()),
        FINISHED(false, DynamicCamera.access$500());

        private final boolean active;
        private final Function<DynamicCamera, Status> tickLogic;

        private Status(boolean active, Function<DynamicCamera, Status> tickLogic) {
            this.active = active;
            this.tickLogic = tickLogic;
        }

        public boolean isActive() {
            return this.active;
        }

        private Status tick(DynamicCamera camera) {
            return this.tickLogic.apply(camera);
        }
    }
}

