/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.entity;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.infinityraider.infinitylib.entity.IInfinityEntityType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class EntityTypeBase<T extends Entity>
extends EntityType<T>
implements IInfinityEntityType {
    private final String name;
    private final Class<T> entityClass;
    private final IRenderFactory<T> renderFactory;

    protected EntityTypeBase(String name, Class<T> entityClass, EntityType.IFactory<T> factory, EntityClassification classification, boolean serializable, boolean summonable, boolean immuneToFire, boolean p_i231489_6_, ImmutableSet<Block> blocks, EntitySize size, int trackingRange, int updateInterval, boolean velocityUpdates, BiFunction<FMLPlayMessages.SpawnEntity, World, T> customClientFactory, Set<Class<? extends MobEntity>> aggressors, IRenderFactory<T> renderFactory) {
        super(factory, classification, serializable, summonable, immuneToFire, p_i231489_6_, blocks, size, trackingRange, updateInterval, t -> velocityUpdates, t -> trackingRange, t -> updateInterval, customClientFactory);
        this.name = name;
        this.entityClass = entityClass;
        this.renderFactory = renderFactory;
        aggressors.forEach(xva$0 -> this.setEntityTargetedBy(new Class[]{xva$0}));
    }

    @Override
    public Class<? extends Entity> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public IRenderFactory<T> getRenderFactory() {
        return this.renderFactory;
    }

    @Override
    @Nonnull
    public String getInternalName() {
        return this.name;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public static <T extends Entity> Builder<T> entityTypeBuilder(String name, Class<T> entityClass, EntityType.IFactory<T> clientFactory, EntityClassification classification, EntitySize size) {
        return new Builder<T>(name, entityClass, clientFactory, classification, size);
    }

    public static <T extends Entity> Builder<T> entityTypeBuilder(String name, Class<T> entityClass, BiFunction<FMLPlayMessages.SpawnEntity, World, T> clientFactory, EntityClassification classification, EntitySize size) {
        return new Builder<T>(name, entityClass, clientFactory, classification, size);
    }

    public static class Builder<T extends Entity> {
        protected final String name;
        protected final Class<T> entityClass;
        protected final EntityClassification classification;
        protected final EntitySize size;
        protected final Set<Block> blocks;
        protected final Set<Class<? extends MobEntity>> aggressors;
        protected EntityType.IFactory<T> factory;
        protected boolean serializable;
        protected boolean summonable;
        protected boolean immuneToFire;
        protected boolean p_i231489_6_;
        protected int trackingRange;
        protected int updateInterval;
        protected boolean velocityUpdates;
        protected BiFunction<FMLPlayMessages.SpawnEntity, World, T> customClientFactory;
        protected IRenderFactory<T> renderFactory;

        private Builder(String name, Class<T> entityClass, EntityClassification classification, EntitySize size) {
            this.name = name;
            this.entityClass = entityClass;
            this.classification = classification;
            this.size = size;
            this.blocks = Sets.newIdentityHashSet();
            this.aggressors = Sets.newIdentityHashSet();
            this.trackingRange = 32;
            this.updateInterval = 1;
        }

        protected Builder(String name, Class<T> entityClass, EntityType.IFactory<T> factory, EntityClassification classification, EntitySize size) {
            this(name, entityClass, classification, size);
            this.factory = factory;
        }

        protected Builder(String name, Class<T> entityClass, BiFunction<FMLPlayMessages.SpawnEntity, World, T> factory, EntityClassification classification, EntitySize size) {
            this(name, entityClass, classification, size);
            this.customClientFactory = factory;
        }

        public EntityTypeBase<T> build() {
            return new EntityTypeBase<T>(this.name, this.entityClass, this.factory, this.classification, this.serializable, this.summonable, this.immuneToFire, this.p_i231489_6_, (ImmutableSet<Block>)ImmutableSet.copyOf(this.blocks), this.size, this.trackingRange, this.updateInterval, this.velocityUpdates, this.customClientFactory, this.aggressors, this.renderFactory);
        }

        public Builder<T> setCommonEntityFactory(EntityType.IFactory<T> factory) {
            this.factory = factory;
            return this;
        }

        public Builder<T> setClientEntityFactory(BiFunction<FMLPlayMessages.SpawnEntity, World, T> factory) {
            this.customClientFactory = factory;
            return this;
        }

        public Builder<T> setSerializable() {
            return this.setSerializable(true);
        }

        public Builder<T> setSerializable(boolean value) {
            this.serializable = value;
            return this;
        }

        public Builder<T> setSummonable(boolean value) {
            this.summonable = value;
            return this;
        }

        public Builder<T> setImmuneToFire(boolean value) {
            this.immuneToFire = value;
            return this;
        }

        public Builder<T> setMysteryBoolean(boolean value) {
            this.p_i231489_6_ = value;
            return this;
        }

        public Builder<T> addBlockForSomeReason(Block block) {
            this.blocks.add(block);
            return this;
        }

        public Builder<T> addBlocksForSomeReason(Collection<Block> blocks) {
            this.blocks.addAll(blocks);
            return this;
        }

        public Builder<T> addBlocksForSomeReason(Block ... blocks) {
            this.blocks.addAll(Arrays.asList(blocks));
            return this;
        }

        public Builder<T> setTrackingRange(int value) {
            this.trackingRange = value;
            return this;
        }

        public Builder<T> setUpdateInterval(int value) {
            this.updateInterval = value;
            return this;
        }

        public Builder<T> setVelocityUpdates(boolean value) {
            this.velocityUpdates = value;
            return this;
        }

        public Builder<T> addAggressor(Class<? extends MobEntity> aggressor) {
            this.aggressors.add(aggressor);
            return this;
        }

        public Builder<T> addAggressors(Collection<Class<? extends MobEntity>> aggressors) {
            this.aggressors.addAll(aggressors);
            return this;
        }

        public Builder<T> addAggressors(Class<? extends MobEntity> ... aggressors) {
            this.aggressors.addAll(Arrays.asList(aggressors));
            return this;
        }

        public Builder<T> setRenderFactory(IRenderFactory factory) {
            this.renderFactory = factory;
            return this;
        }
    }
}

