/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.crafting.dynamictexture;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.crafting.IInfIngredientSerializer;
import com.infinityraider.infinitylib.crafting.dynamictexture.IDynamicTextureIngredient;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class DynamicTextureIngredient
extends Ingredient
implements IDynamicTextureIngredient {
    public static final ResourceLocation ID = new ResourceLocation(InfinityLib.instance.getModId(), "dynamic_material");
    public static final Serializer SERIALIZER = new Serializer();
    private final BlockTagList tagList;

    protected DynamicTextureIngredient(ResourceLocation tagId) {
        this(new BlockTagList(tagId));
    }

    protected DynamicTextureIngredient(BlockTagList tagList) {
        super(Stream.of(tagList));
        this.tagList = tagList;
    }

    @Override
    public ResourceLocation getTagId() {
        return this.tagList.getTagId();
    }

    @Override
    public ITag<Block> getTag() {
        return this.tagList.getTag();
    }

    @Override
    public ItemStack asStackWithMaterial(ItemStack material) {
        return material;
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && !stack.func_190926_b() && this.getTag().func_230236_b_().stream().map(Block::func_199767_j).anyMatch(item -> stack.func_77973_b().equals(item));
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    public static final class BlockTagList
    implements Ingredient.IItemList {
        private final ResourceLocation tagId;
        private ITag<Block> tag;
        private Collection<ItemStack> stacks;

        public BlockTagList(ResourceLocation tagId) {
            this.tagId = tagId;
        }

        public ResourceLocation getTagId() {
            return this.tagId;
        }

        public ITag<Block> getTag() {
            if (this.tag == null) {
                this.tag = BlockTags.func_199896_a().func_199910_a(this.getTagId());
            }
            return this.tag;
        }

        @Nonnull
        public Collection<ItemStack> func_199799_a() {
            if (this.stacks == null) {
                ITag<Block> tag = this.getTag();
                if (tag == null) {
                    return ImmutableList.of();
                }
                this.stacks = tag.func_230236_b_().stream().map(Block::func_199767_j).map(ItemStack::new).collect(Collectors.toList());
            }
            return this.stacks;
        }

        public JsonObject func_200303_b() {
            JsonObject json = new JsonObject();
            json.addProperty("material", this.getTagId().toString());
            return json;
        }
    }

    private static final class Serializer
    implements IInfIngredientSerializer<DynamicTextureIngredient> {
        private Serializer() {
        }

        @Override
        public ResourceLocation getId() {
            return ID;
        }

        public DynamicTextureIngredient parse(PacketBuffer buffer) {
            return new DynamicTextureIngredient(buffer.func_192575_l());
        }

        public DynamicTextureIngredient parse(JsonObject json) {
            if (!json.has("material")) {
                throw new JsonParseException("com.infinityraider.infinitylib.crafting.DynamicTextureIngredient requires a material element");
            }
            return new DynamicTextureIngredient(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"material")));
        }

        public void write(PacketBuffer buffer, DynamicTextureIngredient ingredient) {
            buffer.func_192572_a(ingredient.getTagId());
        }
    }
}

