/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.playerprops;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import mcjty.rftoolsutility.playerprops.PlayerBuff;
import mcjty.rftoolsutility.playerprops.SendBuffsToClientHelper;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSendBuffsToClient {
    private List<PlayerBuff> buffs;

    public void toBytes(PacketBuffer buf) {
        buf.writeByte(this.buffs.size());
        for (PlayerBuff buff : this.buffs) {
            buf.writeByte(buff.ordinal());
        }
    }

    public PacketSendBuffsToClient() {
        this.buffs = null;
    }

    public PacketSendBuffsToClient(PacketBuffer buf) {
        int size = buf.readByte();
        this.buffs = new ArrayList<PlayerBuff>(size);
        for (int i = 0; i < size; ++i) {
            this.buffs.add(PlayerBuff.values()[buf.readByte()]);
        }
    }

    public PacketSendBuffsToClient(Map<PlayerBuff, Integer> buffs) {
        this.buffs = new ArrayList<PlayerBuff>(buffs.keySet());
    }

    public List<PlayerBuff> getBuffs() {
        return this.buffs;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> SendBuffsToClientHelper.setBuffs(this));
        ctx.setPacketHandled(true);
    }
}

