/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter;

import java.util.UUID;
import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SoundTools;
import mcjty.rftoolsutility.modules.teleporter.TeleportConfiguration;
import mcjty.rftoolsutility.modules.teleporter.blocks.DialingDeviceTileEntity;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterReceiverTileEntity;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterTransmitterTileEntity;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import mcjty.rftoolsutility.setup.ModSounds;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.registries.ForgeRegistries;

public class TeleportationTools {
    public static final int STATUS_OK = 0;
    public static final int STATUS_WARN = 1;
    public static final int STATUS_UNKNOWN = 2;
    public static Potion confusion;
    public static Potion harm;
    public static Potion wither;

    public static void getPotions() {
        if (confusion == null) {
            confusion = (Potion)ForgeRegistries.POTION_TYPES.getValue(new ResourceLocation("nausea"));
            harm = (Potion)ForgeRegistries.POTION_TYPES.getValue(new ResourceLocation("instant_damage"));
            wither = (Potion)ForgeRegistries.POTION_TYPES.getValue(new ResourceLocation("wither"));
        }
    }

    public static void applyEffectForSeverity(PlayerEntity player, int severity, boolean boostNeeded) {
        TeleportationTools.getPotions();
        switch (severity) {
            case 1: {
                if (!boostNeeded) break;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                player.func_70097_a(DamageSource.field_76377_j, 0.5f);
                break;
            }
            case 4: {
                player.func_70097_a(DamageSource.field_76377_j, 0.5f);
                break;
            }
            case 5: {
                player.func_70097_a(DamageSource.field_76377_j, 1.0f);
                break;
            }
            case 6: {
                player.func_70097_a(DamageSource.field_76377_j, 1.0f);
                break;
            }
            case 7: {
                player.func_70097_a(DamageSource.field_76377_j, 2.0f);
                break;
            }
            case 8: {
                player.func_70097_a(DamageSource.field_76377_j, 2.0f);
                break;
            }
            case 9: {
                player.func_70097_a(DamageSource.field_76377_j, 3.0f);
                break;
            }
            case 10: {
                player.func_70097_a(DamageSource.field_76377_j, 3.0f);
            }
        }
    }

    public static int calculateRFCost(World world, BlockPos c1, TeleportDestination teleportDestination) {
        if (!world.func_234923_W_().equals(teleportDestination.getDimension())) {
            return (Integer)TeleportConfiguration.rfStartTeleportBaseDim.get();
        }
        BlockPos c2 = teleportDestination.getCoordinate();
        double dist = new Vector3d((double)c1.func_177958_n(), (double)c1.func_177956_o(), (double)c1.func_177952_p()).func_72438_d(new Vector3d((double)c2.func_177958_n(), (double)c2.func_177956_o(), (double)c2.func_177952_p()));
        int rf = (Integer)TeleportConfiguration.rfStartTeleportBaseLocal.get() + (int)((double)((Integer)TeleportConfiguration.rfStartTeleportDist.get()).intValue() * dist);
        if (rf > (Integer)TeleportConfiguration.rfStartTeleportBaseDim.get()) {
            rf = (Integer)TeleportConfiguration.rfStartTeleportBaseDim.get();
        }
        return rf;
    }

    public static int calculateTime(World world, BlockPos c1, TeleportDestination teleportDestination) {
        if (!world.func_234923_W_().equals(teleportDestination.getDimension())) {
            return (Integer)TeleportConfiguration.timeTeleportBaseDim.get();
        }
        BlockPos c2 = teleportDestination.getCoordinate();
        double dist = new Vector3d((double)c1.func_177958_n(), (double)c1.func_177956_o(), (double)c1.func_177952_p()).func_72438_d(new Vector3d((double)c2.func_177958_n(), (double)c2.func_177956_o(), (double)c2.func_177952_p()));
        int time = (Integer)TeleportConfiguration.timeTeleportBaseLocal.get() + (int)((double)((Integer)TeleportConfiguration.timeTeleportDist.get()).intValue() * dist / 1000.0);
        if (time > (Integer)TeleportConfiguration.timeTeleportBaseDim.get()) {
            time = (Integer)TeleportConfiguration.timeTeleportBaseDim.get();
        }
        return time;
    }

    public static boolean performTeleport(PlayerEntity player, TeleportDestination dest, int bad, int good, boolean boosted) {
        BlockPos c = dest.getCoordinate();
        BlockPos old = new BlockPos((int)player.func_226277_ct_(), (int)player.func_226278_cu_(), (int)player.func_226281_cx_());
        RegistryKey oldId = player.func_130014_f_().func_234923_W_();
        if (!TeleportationTools.allowTeleport((Entity)player, (RegistryKey<World>)oldId, old, dest.getDimension(), dest.getCoordinate())) {
            return false;
        }
        if (!oldId.equals(dest.getDimension())) {
            mcjty.lib.varia.TeleportationTools.teleportToDimension((PlayerEntity)player, dest.getDimension(), (double)((double)c.func_177958_n() + 0.5), (double)((double)c.func_177956_o() + 1.5), (double)((double)c.func_177952_p() + 0.5));
        } else {
            player.func_70634_a((double)c.func_177958_n() + 0.5, (double)(c.func_177956_o() + 1), (double)c.func_177952_p() + 0.5);
        }
        if (((Boolean)TeleportConfiguration.whooshMessage.get()).booleanValue()) {
            Logging.message((PlayerEntity)player, (String)"Whoosh!");
        }
        boolean boostNeeded = false;
        int severity = TeleportationTools.consumeReceiverEnergy(player, dest.getCoordinate(), dest.getDimension());
        if (severity > 0 && boosted) {
            boostNeeded = true;
            severity = 1;
        }
        if ((severity = TeleportationTools.applyBadEffectIfNeeded(player, severity, bad, good, boostNeeded)) <= 0 && (Double)TeleportConfiguration.teleportVolume.get() >= 0.01) {
            SoundTools.playSound((World)player.func_130014_f_(), (SoundEvent)ModSounds.whoosh, (double)player.func_226277_ct_(), (double)player.func_226278_cu_(), (double)player.func_226281_cx_(), (double)((Double)TeleportConfiguration.teleportVolume.get()), (double)1.0);
        }
        if (((Boolean)TeleportConfiguration.logTeleportUsages.get()).booleanValue()) {
            Logging.log((String)("Teleport: Player " + player.func_200200_C_() + " from " + old + " (dim " + oldId + ") to " + dest.getCoordinate() + " (dim " + dest.getDimension() + ") with severity " + severity));
        }
        return boostNeeded;
    }

    public static int dial(World worldObj, DialingDeviceTileEntity dialingDeviceTileEntity, UUID player, BlockPos transmitter, RegistryKey<World> transDim, BlockPos coordinate, RegistryKey<World> dimension, boolean once) {
        ServerWorld transWorld = LevelTools.getLevel(transDim);
        if (transWorld == null) {
            return 256;
        }
        MatterTransmitterTileEntity transmitterTileEntity = (MatterTransmitterTileEntity)transWorld.func_175625_s(transmitter);
        if (transmitterTileEntity == null) {
            return 1024;
        }
        if (player != null && !transmitterTileEntity.checkAccess(player)) {
            return 32;
        }
        if (coordinate == null) {
            transmitterTileEntity.setTeleportDestination(null, false);
            return 128;
        }
        TeleportDestination teleportDestination = TeleportationTools.findDestination(worldObj, coordinate, dimension);
        if (teleportDestination == null) {
            return 4;
        }
        BlockPos c = teleportDestination.getCoordinate();
        ServerWorld recWorld = LevelTools.getLevel(teleportDestination.getDimension());
        if (recWorld == null && (recWorld = LevelTools.getLevel((World)worldObj, teleportDestination.getDimension())) == null) {
            return 4;
        }
        TileEntity tileEntity = recWorld.func_175625_s(c);
        if (!(tileEntity instanceof MatterReceiverTileEntity)) {
            return 4;
        }
        MatterReceiverTileEntity receiver = (MatterReceiverTileEntity)tileEntity;
        TeleportDestination destination = receiver.updateDestination();
        if (player != null && !destination.checkAccess((World)recWorld, player)) {
            return 64;
        }
        if (!TeleportationTools.checkBeam(transmitter, (World)transWorld, 1, 4, 2)) {
            return 2;
        }
        if (dialingDeviceTileEntity != null && !dialingDeviceTileEntity.getCapability(CapabilityEnergy.ENERGY).map(h -> {
            int defaultCost = (Integer)TeleportConfiguration.rfPerDial.get();
            int cost = dialingDeviceTileEntity.getCapability(CapabilityInfusable.INFUSABLE_CAPABILITY).map(inf -> (int)((float)defaultCost * (2.0f - inf.getInfusedFactor()) / 2.0f)).orElse(defaultCost);
            if (h.getEnergyStored() < cost) {
                return false;
            }
            ((GenericEnergyStorage)h).consumeEnergy((long)cost);
            return true;
        }).orElse(false).booleanValue()) {
            return 8;
        }
        transmitterTileEntity.setTeleportDestination(teleportDestination, once);
        return 0;
    }

    private static int consumeReceiverEnergy(PlayerEntity player, BlockPos c, RegistryKey<World> dimension) {
        ServerWorld world = LevelTools.getLevel((World)player.field_70170_p, dimension);
        if (world == null) {
            Logging.warn((PlayerEntity)player, (String)"Something went wrong with the destination!");
            return 0;
        }
        TileEntity te = world.func_175625_s(c);
        if (!(te instanceof MatterReceiverTileEntity)) {
            Logging.warn((PlayerEntity)player, (String)"Something went wrong with the destination!");
            return 0;
        }
        MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)te;
        return matterReceiverTileEntity.getCapability(CapabilityEnergy.ENERGY).map(h -> {
            int defaultCost = (Integer)TeleportConfiguration.rfPerTeleportReceiver.get();
            int rf = matterReceiverTileEntity.getCapability(CapabilityInfusable.INFUSABLE_CAPABILITY).map(inf -> (int)((float)defaultCost * (2.0f - inf.getInfusedFactor()) / 2.0f)).orElse(defaultCost);
            if (rf <= 0) {
                return 0;
            }
            int extracted = Math.min(rf, h.getEnergyStored());
            ((GenericEnergyStorage)h).consumeEnergy((long)rf);
            long remainingRf = ((GenericEnergyStorage)h).getEnergy();
            if (remainingRf <= 1L) {
                Logging.warn((PlayerEntity)player, (String)"The matter receiver has run out of power!");
            } else if (remainingRf < (long)((Integer)TeleportConfiguration.RECEIVER_MAXENERGY.get() / 10)) {
                Logging.warn((PlayerEntity)player, (String)"The matter receiver is getting very low on power!");
            } else if (remainingRf < (long)((Integer)TeleportConfiguration.RECEIVER_MAXENERGY.get() / 5)) {
                Logging.warn((PlayerEntity)player, (String)"The matter receiver is getting low on power!");
            }
            return 10 - extracted * 10 / rf;
        }).orElse(0);
    }

    public static int calculateSeverity(int bad, int total) {
        if (total == 0) {
            total = 1;
        }
        int severity = bad * 10 / total;
        if (TeleportationTools.mustInterrupt(bad, total)) {
            severity += 2;
        }
        if (severity > 10) {
            severity = 10;
        }
        return severity;
    }

    public static int applyBadEffectIfNeeded(PlayerEntity player, int severity, int bad, int total, boolean boostNeeded) {
        if (player == null) {
            return 0;
        }
        if ((severity += TeleportationTools.calculateSeverity(bad, total)) > 10) {
            severity = 10;
        }
        if (severity <= 0) {
            return 0;
        }
        if ((Double)TeleportConfiguration.teleportErrorVolume.get() >= 0.01) {
            SoundTools.playSound((World)player.func_130014_f_(), (SoundEvent)ModSounds.error, (double)player.func_226277_ct_(), (double)player.func_226278_cu_(), (double)player.func_226281_cx_(), (double)((Double)TeleportConfiguration.teleportErrorVolume.get()), (double)1.0);
        }
        TeleportationTools.applyEffectForSeverity(player, severity, boostNeeded);
        return severity;
    }

    public static boolean mustInterrupt(int bad, int total) {
        return bad > total / 2;
    }

    public static boolean allowTeleport(Entity entity, RegistryKey<World> sourceDim, BlockPos source, RegistryKey<World> destDim, BlockPos dest) {
        return true;
    }

    public static TeleportDestination findDestination(World worldObj, BlockPos coordinate, RegistryKey<World> dimension) {
        TeleportDestinations destinations = TeleportDestinations.get(worldObj);
        return destinations.getDestination(coordinate, dimension);
    }

    public static boolean checkBeam(BlockPos c, World world, int dy1, int dy2, int errory) {
        for (int dy = dy1; dy <= dy2; ++dy) {
            BlockPos pos = new BlockPos(c.func_177958_n(), c.func_177956_o() + dy, c.func_177952_p());
            BlockState state = world.func_180495_p(pos);
            Block b = state.func_177230_c();
            if (b.isAir(state, (IBlockReader)world, pos)) continue;
            if (dy > errory) break;
            return false;
        }
        return true;
    }

    public static boolean checkValidTeleport(PlayerEntity player, RegistryKey<World> srcId, RegistryKey<World> dstId) {
        if (((Boolean)TeleportConfiguration.preventInterdimensionalTeleports.get()).booleanValue() && srcId.equals(dstId)) {
            Logging.warn((PlayerEntity)player, (String)"Teleportation in the same dimension is not allowed!");
            return false;
        }
        if (TeleportConfiguration.getBlacklistedTeleportationDestinations().contains(dstId)) {
            Logging.warn((PlayerEntity)player, (String)"Teleportation to that dimension is not allowed!");
            return false;
        }
        if (TeleportConfiguration.getBlacklistedTeleportationSources().contains(srcId)) {
            Logging.warn((PlayerEntity)player, (String)"Teleportation from this dimension is not allowed!");
            return false;
        }
        return true;
    }
}

