/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.spawner.items;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.NBTTools;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.spawner.SpawnerConfiguration;
import mcjty.rftoolsutility.modules.spawner.SpawnerModule;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

public class SyringeItem
extends Item {
    public static final int MAX_SYRINGE_MODEL_LEVEL = 5;
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.parameter((String)"level", this::getLevelString), TooltipBuilder.parameter((String)"mob", this::hasMob, SyringeItem::getMobName), TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"level", this::getLevelString), TooltipBuilder.parameter((String)"mob", this::hasMob, SyringeItem::getMobName)});

    public SyringeItem() {
        super(new Item.Properties().func_200916_a(RFToolsUtility.setup.getTab()).func_200917_a(1));
    }

    private String getLevelString(ItemStack stack) {
        return Integer.toString(SyringeItem.getLevel(stack));
    }

    private boolean hasMob(ItemStack stack) {
        return SyringeItem.getMobId(stack) != null;
    }

    public static int getLevel(ItemStack stack) {
        return NBTTools.getInt((ItemStack)stack, (String)"level", (int)0) * 100 / (Integer)SpawnerConfiguration.maxMobInjections.get();
    }

    public static void initOverrides(SyringeItem item) {
        ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)new ResourceLocation("rftoolsutility", "level"), (stack, world, livingEntity) -> {
            int level = NBTTools.getInt((ItemStack)stack, (String)"level", (int)0);
            level = level * 5 / (Integer)SpawnerConfiguration.maxMobInjections.get();
            return level;
        });
    }

    public void func_77624_a(@Nonnull ItemStack itemStack, World world, @Nonnull List<ITextComponent> list, @Nonnull ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(this.getRegistryName(), itemStack, list, flag);
    }

    @Nullable
    public static LivingEntity getEntityLivingFromClickedEntity(Entity entity) {
        if (entity instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    public static ItemStack createMobSyringe(ResourceLocation mobId) {
        ItemStack syringe = new ItemStack((IItemProvider)SpawnerModule.SYRINGE.get());
        CompoundNBT tagCompound = new CompoundNBT();
        tagCompound.func_74778_a("mobId", mobId.toString());
        tagCompound.func_74768_a("level", ((Integer)SpawnerConfiguration.maxMobInjections.get()).intValue());
        syringe.func_77982_d(tagCompound);
        return syringe;
    }

    public static String getMobId(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            return tagCompound.func_74779_i("mobId");
        }
        return null;
    }

    public static String getMobName(ItemStack stack) {
        String id = SyringeItem.getMobId(stack);
        EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id));
        if (type != null) {
            return type.func_212546_e().getString();
        }
        return id;
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this));
            for (Map.Entry entry : ForgeRegistries.ENTITIES.getEntries()) {
                ResourceLocation id = ((RegistryKey)entry.getKey()).func_240901_a_();
                if (((EntityType)entry.getValue()).func_220339_d() == EntityClassification.MISC) continue;
                items.add((Object)SyringeItem.createMobSyringe(id));
            }
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            CompoundNBT tagCompound = stack.func_77978_p();
            if (tagCompound != null) {
                String mobName = SyringeItem.getMobName(stack);
                if (mobName != null) {
                    Logging.message((PlayerEntity)player, (String)(TextFormatting.BLUE + "Mob: " + mobName));
                }
                int level = tagCompound.func_74762_e("level");
                level = level * 100 / (Integer)SpawnerConfiguration.maxMobInjections.get();
                Logging.message((PlayerEntity)player, (String)(TextFormatting.BLUE + "Essence level: " + level + "%"));
            }
            return ActionResult.func_226248_a_((Object)stack);
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        LivingEntity entityLiving = SyringeItem.getEntityLivingFromClickedEntity(entity);
        if (entityLiving != null) {
            String prevMobId = null;
            CompoundNBT tagCompound = stack.func_77978_p();
            if (tagCompound != null) {
                prevMobId = tagCompound.func_74779_i("mobId");
            } else {
                tagCompound = new CompoundNBT();
                stack.func_77982_d(tagCompound);
            }
            String id = this.findSelectedMobId((Entity)entityLiving);
            if (id != null && !id.isEmpty()) {
                if (!id.equals(prevMobId)) {
                    tagCompound.func_74778_a("mobName", entityLiving.func_200600_R().getRegistryName().toString());
                    tagCompound.func_74778_a("mobId", id);
                    tagCompound.func_74768_a("level", 1);
                } else {
                    tagCompound.func_74768_a("level", Math.min(tagCompound.func_74762_e("level") + 1, (Integer)SpawnerConfiguration.maxMobInjections.get()));
                }
            }
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    private String findSelectedMobId(Entity entity) {
        ResourceLocation key = entity.func_200600_R().getRegistryName();
        return key != null ? key.toString() : null;
    }
}

