/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modules;

import java.util.Objects;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.data.IModuleDataInteger;
import mcjty.rftoolsutility.modules.logic.tools.RedstoneChannels;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class RedstoneScreenModule
implements IScreenModule<IModuleDataInteger> {
    private int channel = -1;
    private BlockPos coordinate = BlockPosTools.INVALID;
    private RegistryKey<World> dim = World.field_234918_g_;
    private Direction side = null;

    public IModuleDataInteger getData(IScreenDataHelper helper, World worldObj, long millis) {
        if (this.channel == -1) {
            ServerWorld world;
            if (!BlockPosTools.INVALID.equals((Object)this.coordinate) && (world = LevelTools.getLevel((World)worldObj, this.dim)) != null) {
                int powerTo = world.func_175651_c(this.coordinate.func_177972_a(this.side), this.side.func_176734_d());
                return helper.createInteger(powerTo);
            }
            return null;
        }
        RedstoneChannels channels = RedstoneChannels.getChannels(worldObj);
        if (channels == null) {
            return null;
        }
        RedstoneChannels.RedstoneChannel ch = channels.getChannel(this.channel);
        if (ch == null) {
            return null;
        }
        return helper.createInteger(ch.getValue());
    }

    public void setupFromNBT(CompoundNBT tagCompound, RegistryKey<World> dim, BlockPos pos) {
        if (tagCompound != null) {
            this.channel = -1;
            if (tagCompound.func_74764_b("channel")) {
                this.channel = tagCompound.func_74762_e("channel");
            }
            if (tagCompound.func_74764_b("monitorx")) {
                this.side = OrientationTools.DIRECTION_VALUES[tagCompound.func_74762_e("monitorside")];
                this.dim = LevelTools.getId((String)tagCompound.func_74779_i("monitordim"));
                if (Objects.equals(dim, this.dim)) {
                    BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                    int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
                    int dy = Math.abs(c.func_177956_o() - pos.func_177956_o());
                    int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
                    if (dx <= 64 && dy <= 64 && dz <= 64) {
                        this.coordinate = c;
                    }
                }
            }
        }
    }

    public int getRfPerTick() {
        return (Integer)ScreenConfiguration.REDSTONE_RFPERTICK.get();
    }

    public void mouseClick(World world, int x, int y, boolean clicked, PlayerEntity player) {
    }
}

