/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Type;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.blocks.RedstoneChannelTileEntity;
import mcjty.rftoolsutility.modules.logic.network.PacketSetChannelName;
import mcjty.rftoolsutility.modules.logic.tools.RedstoneChannels;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.util.LazyOptional;

public class RedstoneTransmitterTileEntity
extends RedstoneChannelTileEntity {
    private int prevIn = -1;
    private String channelName;
    @GuiValue
    public static final Value<?, String> VALUE_NAME = Value.create((String)"name", (Type)Type.STRING, RedstoneTransmitterTileEntity::getChannelName, RedstoneTransmitterTileEntity::setChannelName);
    @Cap(type=CapType.CONTAINER)
    private LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Redstone Receiver").containerSupplier(DefaultContainerProvider.empty(LogicBlockModule.CONTAINER_REDSTONE_TRANSMITTER, (GenericTileEntity)this)).setupSync((GenericTileEntity)this));

    public void setChannelName(String v) {
        if (this.field_145850_b.field_72995_K) {
            this.channelName = v;
            RFToolsUtilityMessages.INSTANCE.sendToServer((Object)new PacketSetChannelName(this.field_174879_c, this.channelName));
        } else {
            if (this.channel == -1) {
                this.getChannel(true);
            }
            RedstoneChannels channels = RedstoneChannels.getChannels(this.field_145850_b);
            RedstoneChannels.RedstoneChannel ch = channels.getOrCreateChannel(this.channel);
            ch.setName(v);
            channels.func_76185_a();
            this.func_70296_d();
        }
    }

    private String getChannelName() {
        if (this.field_145850_b.field_72995_K) {
            return this.channelName;
        }
        if (this.channel == -1) {
            return "";
        }
        RedstoneChannels channels = RedstoneChannels.getChannels(this.field_145850_b);
        RedstoneChannels.RedstoneChannel ch = channels.getOrCreateChannel(this.channel);
        return ch.getName();
    }

    public RedstoneTransmitterTileEntity() {
        super((TileEntityType)LogicBlockModule.TYPE_REDSTONE_TRANSMITTER.get());
    }

    public void saveClientDataToNBT(CompoundNBT tagCompound) {
        tagCompound.func_74778_a("channelName", this.getChannelName());
    }

    public void loadClientDataFromNBT(CompoundNBT tagCompound) {
        this.channelName = tagCompound.func_74779_i("channelName");
    }

    @Override
    public void setChannel(int channel) {
        super.setChannel(channel);
        this.update();
    }

    public void update() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.channel == -1) {
            return;
        }
        if (this.powerLevel != this.prevIn) {
            this.prevIn = this.powerLevel;
            this.func_70296_d();
            RedstoneChannels channels = RedstoneChannels.getChannels(this.field_145850_b);
            RedstoneChannels.RedstoneChannel ch = channels.getOrCreateChannel(this.channel);
            ch.setValue(this.powerLevel);
            channels.save();
        }
    }

    public void load(CompoundNBT tagCompound) {
        super.load(tagCompound);
        this.prevIn = tagCompound.func_150297_b("prevIn", 3) ? tagCompound.func_74762_e("prevIn") : (tagCompound.func_74767_n("prevIn") ? 15 : 0);
    }

    public void saveAdditional(@Nonnull CompoundNBT tagCompound) {
        super.saveAdditional(tagCompound);
        tagCompound.func_74768_a("prevIn", this.prevIn);
    }
}

