/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental.blocks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.information.IPowerInformation;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.api.module.DefaultModuleSupport;
import mcjty.lib.api.module.IModuleSupport;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.NamedEnum;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.environmental.EnvModuleProvider;
import mcjty.rftoolsutility.modules.environmental.EnvironmentalConfiguration;
import mcjty.rftoolsutility.modules.environmental.EnvironmentalModule;
import mcjty.rftoolsutility.modules.environmental.modules.EnvironmentModule;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;

public class EnvironmentalControllerTileEntity
extends TickingTileEntity {
    public static final String COMPONENT_NAME = "environmental_controller";
    public static final int ENV_MODULES = 7;
    public static final int SLOT_MODULES = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(7).box(SlotDefinition.specific(s -> s.func_77973_b() instanceof EnvModuleProvider).in().out(), 0, 7, 8, 1, 7).playerSlots(27, 142));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((slot, stack) -> stack.func_77973_b() instanceof EnvModuleProvider).onUpdate((slot, stack) -> {
        this.environmentModules = null;
    }).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)EnvironmentalConfiguration.ENVIRONMENTAL_MAXENERGY.get()).intValue(), (long)((Integer)EnvironmentalConfiguration.ENVIRONMENTAL_RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.INFUSABLE)
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((TileEntity)this));
    @Cap(type=CapType.POWER_INFO)
    private final LazyOptional<IPowerInformation> powerInfoHandler = LazyOptional.of(this::createPowerInfo);
    @Cap(type=CapType.MODULE)
    private final LazyOptional<IModuleSupport> moduleSupportHandler = LazyOptional.of(() -> new DefaultModuleSupport(0, 6){

        public boolean isModule(ItemStack itemStack) {
            return itemStack.func_77973_b() instanceof EnvModuleProvider;
        }
    });
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Environmental Controller").containerSupplier(DefaultContainerProvider.container(EnvironmentalModule.CONTAINER_ENVIRONENTAL_CONTROLLER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    private List<EnvironmentModule> environmentModules = null;
    public Set<String> players = new HashSet<String>();
    private int totalRfPerTick = 0;
    @GuiValue
    private EnvironmentalMode mode = EnvironmentalMode.MODE_BLACKLIST;
    private int radius = 50;
    @GuiValue
    public static final Value<?, ?> VALUE_RADIUS = Value.create((String)"radius", (Type)Type.INTEGER, EnvironmentalControllerTileEntity::getRadius, EnvironmentalControllerTileEntity::setRadius);
    @GuiValue
    private int miny = 30;
    @GuiValue
    private int maxy = 70;
    private int volume = -1;
    private boolean active = false;
    private int powerTimeout = 0;
    @ServerCommand
    public static final Command<?> CMD_RSMODE = Command.create((String)"env.setRsMode", (te, player, params) -> te.setRSMode(RedstoneMode.values()[(Integer)params.get(ImageChoiceLabel.PARAM_CHOICE_IDX)]));
    public static final Key<Integer> PARAM_MIN = new Key("min", Type.INTEGER);
    public static final Key<Integer> PARAM_MAX = new Key("max", Type.INTEGER);
    @ServerCommand
    public static final Command<?> CMD_SETBOUNDS = Command.create((String)"env.setBounds", (te, player, params) -> {
        te.setMiny((Integer)params.get(PARAM_MIN));
        te.setMaxy((Integer)params.get(PARAM_MAX));
    });
    public static final Key<Integer> PARAM_MODE = new Key("mode", Type.INTEGER);
    @ServerCommand
    public static final Command<?> CMD_SETMODE = Command.create((String)"env.setBlacklist", (te, player, params) -> te.setMode(EnvironmentalMode.values()[(Integer)params.get(PARAM_MODE)]));
    public static final Key<String> PARAM_NAME = new Key("name", Type.STRING);
    @ServerCommand
    public static final Command<?> CMD_ADDPLAYER = Command.create((String)"env.addPlayer", (te, player, params) -> te.addPlayer((String)params.get(PARAM_NAME)));
    @ServerCommand
    public static final Command<?> CMD_DELPLAYER = Command.create((String)"env.delPlayer", (te, player, params) -> te.delPlayer((String)params.get(PARAM_NAME)));
    @ServerCommand(type=String.class)
    public static final ListCommand<?, ?> CMD_GETPLAYERS = ListCommand.create((String)"rftoolsutility.env.getPlayers", (te, player, params) -> te.getPlayersAsList(), (te, player, params, list) -> {
        te.players = new HashSet<String>(list);
    });

    public EnvironmentalControllerTileEntity() {
        super((TileEntityType)EnvironmentalModule.TYPE_ENVIRONENTAL_CONTROLLER.get());
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(2.0f).func_200947_a(SoundType.field_185852_e).func_235838_a_(value -> 13)).tileEntitySupplier(EnvironmentalControllerTileEntity::new).topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolsutility:machines/environmental")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()})){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }
        };
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public EnvironmentalMode getMode() {
        return this.mode;
    }

    public void setMode(EnvironmentalMode mode) {
        this.mode = mode;
        this.func_70296_d();
    }

    private float getPowerMultiplier() {
        switch (this.mode) {
            case MODE_BLACKLIST: 
            case MODE_WHITELIST: {
                return 1.0f;
            }
            case MODE_HOSTILE: 
            case MODE_PASSIVE: 
            case MODE_MOBS: 
            case MODE_ALL: {
                return (float)((Double)EnvironmentalConfiguration.mobsPowerMultiplier.get()).doubleValue();
            }
        }
        return 1.0f;
    }

    public boolean isEntityAffected(Entity entity) {
        switch (this.mode) {
            case MODE_BLACKLIST: {
                if (entity instanceof PlayerEntity) {
                    return this.isPlayerAffected((PlayerEntity)entity);
                }
                return false;
            }
            case MODE_WHITELIST: {
                if (entity instanceof PlayerEntity) {
                    return this.isPlayerAffected((PlayerEntity)entity);
                }
                return false;
            }
            case MODE_HOSTILE: {
                return entity instanceof IMob;
            }
            case MODE_PASSIVE: {
                return entity instanceof MobEntity && !(entity instanceof IMob);
            }
            case MODE_MOBS: {
                return entity instanceof MobEntity;
            }
            case MODE_ALL: {
                if (entity instanceof PlayerEntity) {
                    return this.isPlayerAffected((PlayerEntity)entity);
                }
                return true;
            }
        }
        return false;
    }

    public boolean isPlayerAffected(PlayerEntity player) {
        if (this.mode == EnvironmentalMode.MODE_WHITELIST) {
            return this.players.contains(player.func_200200_C_().getString());
        }
        if (this.mode == EnvironmentalMode.MODE_BLACKLIST) {
            return !this.players.contains(player.func_200200_C_().getString());
        }
        return this.mode == EnvironmentalMode.MODE_ALL;
    }

    private List<String> getPlayersAsList() {
        return new ArrayList<String>(this.players);
    }

    private void addPlayer(String player) {
        if (!this.players.contains(player)) {
            this.players.add(player);
            this.func_70296_d();
        }
    }

    private void delPlayer(String player) {
        if (this.players.contains(player)) {
            this.players.remove(player);
            this.func_70296_d();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public int getTotalRfPerTick() {
        if (this.environmentModules == null) {
            this.getEnvironmentModules();
        }
        float factor = this.infusableHandler.map(IInfusable::getInfusedFactor).orElse(Float.valueOf(0.0f)).floatValue();
        int rfNeeded = (int)((float)this.totalRfPerTick * this.getPowerMultiplier() * (4.0f - factor) / 4.0f);
        if (this.environmentModules.isEmpty()) {
            return rfNeeded;
        }
        if (rfNeeded < (Integer)EnvironmentalConfiguration.MIN_USAGE.get()) {
            rfNeeded = (Integer)EnvironmentalConfiguration.MIN_USAGE.get();
        }
        return rfNeeded;
    }

    public int getVolume() {
        if (this.volume == -1) {
            this.volume = (int)((double)(this.radius * this.radius) * Math.PI * (double)(this.maxy - this.miny + 1));
        }
        return this.volume;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.func_70296_d();
        this.volume = -1;
        this.environmentModules = null;
    }

    public int getMiny() {
        return this.miny;
    }

    public void setMiny(int miny) {
        if (miny == -1) {
            return;
        }
        this.miny = miny;
        this.func_70296_d();
        this.volume = -1;
        this.environmentModules = null;
    }

    public int getMaxy() {
        return this.maxy;
    }

    public void setMaxy(int maxy) {
        if (maxy == -1) {
            return;
        }
        this.maxy = maxy;
        this.volume = -1;
        this.environmentModules = null;
        this.func_70296_d();
    }

    protected void tickServer() {
        if (this.powerTimeout > 0) {
            --this.powerTimeout;
            return;
        }
        long rf = this.energyStorage.getEnergyStored();
        if (!this.isMachineEnabled()) {
            rf = 0L;
        }
        this.getEnvironmentModules();
        int rfNeeded = this.getTotalRfPerTick();
        if ((long)rfNeeded > rf || this.environmentModules.isEmpty()) {
            this.deactivate();
            this.powerTimeout = 20;
        } else {
            this.energyStorage.consumeEnergy((long)rfNeeded);
            for (EnvironmentModule module : this.environmentModules) {
                module.activate(true);
                module.tick(this.field_145850_b, this.func_174877_v(), this.radius, this.miny, this.maxy, this);
            }
            if (!this.active) {
                this.active = true;
                this.markDirtyClient();
            }
        }
    }

    public void deactivate() {
        for (EnvironmentModule module : this.environmentModules) {
            module.activate(false);
        }
        if (this.active) {
            this.active = false;
            this.markDirtyClient();
        }
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel != powered) {
            this.powerTimeout = 0;
        }
        super.setPowerInput(powered);
    }

    public List<EnvironmentModule> getEnvironmentModules() {
        if (this.environmentModules == null) {
            int volume = this.getVolume();
            this.totalRfPerTick = 0;
            this.environmentModules = new ArrayList<EnvironmentModule>();
            for (int i = 0; i < this.items.getSlots(); ++i) {
                ItemStack itemStack = this.items.getStackInSlot(i);
                if (itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof EnvModuleProvider)) continue;
                EnvModuleProvider moduleProvider = (EnvModuleProvider)itemStack.func_77973_b();
                Supplier<? extends EnvironmentModule> supplier = moduleProvider.getServerEnvironmentModule();
                EnvironmentModule environmentModule = supplier.get();
                this.environmentModules.add(environmentModule);
                this.totalRfPerTick += (int)(environmentModule.getRfPerTick() * (float)volume);
            }
        }
        return this.environmentModules;
    }

    public void load(CompoundNBT tagCompound) {
        super.load(tagCompound);
        this.totalRfPerTick = tagCompound.func_74762_e("rfPerTick");
        this.active = tagCompound.func_74767_n("active");
    }

    protected void loadInfo(CompoundNBT tagCompound) {
        super.loadInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.radius = info.func_74762_e("radius");
        this.miny = info.func_74762_e("miny");
        this.maxy = info.func_74762_e("maxy");
        this.volume = -1;
        if (info.func_74764_b("whitelist")) {
            boolean wl = info.func_74767_n("whitelist");
            this.mode = wl ? EnvironmentalMode.MODE_WHITELIST : EnvironmentalMode.MODE_BLACKLIST;
        } else {
            int m = info.func_74762_e("mode");
            this.mode = EnvironmentalMode.values()[m];
        }
        this.players.clear();
        ListNBT playerList = info.func_150295_c("players", 8);
        if (!playerList.isEmpty()) {
            for (int i = 0; i < playerList.size(); ++i) {
                String player = playerList.func_150307_f(i);
                this.players.add(player);
            }
        }
    }

    public void loadClientDataFromNBT(CompoundNBT tagCompound) {
        this.active = tagCompound.func_74767_n("active");
    }

    public void saveClientDataToNBT(CompoundNBT tagCompound) {
        tagCompound.func_74757_a("active", this.active);
    }

    public void saveAdditional(@Nonnull CompoundNBT tagCompound) {
        super.saveAdditional(tagCompound);
        tagCompound.func_74768_a("rfPerTick", this.totalRfPerTick);
        tagCompound.func_74757_a("active", this.active);
    }

    protected void saveInfo(CompoundNBT tagCompound) {
        super.saveInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("radius", this.radius);
        info.func_74768_a("miny", this.miny);
        info.func_74768_a("maxy", this.maxy);
        info.func_74768_a("mode", this.mode.ordinal());
        ListNBT playerTagList = new ListNBT();
        for (String player : this.players) {
            playerTagList.add((Object)StringNBT.func_229705_a_((String)player));
        }
        info.func_218657_a("players", (INBT)playerTagList);
    }

    public void onReplaced(World world, BlockPos pos, BlockState state, BlockState newstate) {
        this.deactivate();
    }

    @Nonnull
    private IPowerInformation createPowerInfo() {
        return new IPowerInformation(){

            public long getEnergyDiffPerTick() {
                return EnvironmentalControllerTileEntity.this.isActive() ? (long)(-EnvironmentalControllerTileEntity.this.getTotalRfPerTick()) : 0L;
            }

            @Nullable
            public String getEnergyUnitName() {
                return "RF";
            }

            public boolean isMachineActive() {
                return EnvironmentalControllerTileEntity.this.isActive();
            }

            public boolean isMachineRunning() {
                return EnvironmentalControllerTileEntity.this.isActive();
            }

            @Nullable
            public String getMachineStatus() {
                return EnvironmentalControllerTileEntity.this.isActive() ? "active" : "idle";
            }
        };
    }

    public static enum EnvironmentalMode implements NamedEnum<EnvironmentalMode>
    {
        MODE_BLACKLIST("blacklist"),
        MODE_WHITELIST("whitelist"),
        MODE_HOSTILE("hostile"),
        MODE_PASSIVE("passive"),
        MODE_MOBS("mobs"),
        MODE_ALL("all");

        private final String name;

        private EnvironmentalMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String[] getDescription() {
            return new String[]{this.name};
        }
    }
}

