/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.apiimpl.teleportation;

import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.varia.TeleportationTools;
import mcjty.rftoolsbase.api.teleportation.ITeleportationManager;
import mcjty.rftoolsutility.modules.teleporter.TeleportConfiguration;
import mcjty.rftoolsutility.modules.teleporter.TeleporterModule;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterReceiverTileEntity;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.World;

public class TeleportationManager
implements ITeleportationManager {
    public String getReceiverName(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() == TeleporterModule.MATTER_RECEIVER.get()) {
            MatterReceiverTileEntity te = (MatterReceiverTileEntity)world.func_175625_s(pos);
            return te.getName();
        }
        return null;
    }

    public boolean createReceiver(World world, BlockPos pos, String name, int power) {
        world.func_180501_a(pos, ((BaseBlock)TeleporterModule.MATTER_RECEIVER.get()).func_176223_P(), 2);
        MatterReceiverTileEntity te = (MatterReceiverTileEntity)world.func_175625_s(pos);
        if (power == -1) {
            te.storeEnergy(((Integer)TeleportConfiguration.RECEIVER_MAXENERGY.get()).intValue());
        } else {
            te.storeEnergy(Math.min(power, (Integer)TeleportConfiguration.RECEIVER_MAXENERGY.get()));
        }
        te.setName(name);
        te.func_70296_d();
        this.registerReceiver(world, pos, name);
        return true;
    }

    private void registerReceiver(World world, BlockPos pos, String name) {
        TeleportDestinations destinations = TeleportDestinations.get(world);
        GlobalPos gc = GlobalPos.func_239648_a_((RegistryKey)world.func_234923_W_(), (BlockPos)pos);
        TeleportDestination destination = destinations.addDestination(gc);
        destination.setName(name);
        destinations.save();
    }

    public void teleportPlayer(PlayerEntity player, RegistryKey<World> dimension, BlockPos location) {
        TeleportationTools.teleportToDimension((PlayerEntity)player, dimension, (double)location.func_177958_n(), (double)location.func_177956_o(), (double)location.func_177952_p());
    }

    public void removeReceiverDestinations(World world, RegistryKey<World> dim) {
        TeleportDestinations destinations = TeleportDestinations.get(world);
        destinations.removeDestinationsInDimension(dim);
        destinations.save();
    }
}

