/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.village;

import com.mojang.datafixers.util.Pair;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.DesertVillagePools;
import net.minecraft.world.gen.feature.structure.PlainsVillagePools;
import net.minecraft.world.gen.feature.structure.SavannaVillagePools;
import net.minecraft.world.gen.feature.structure.SnowyVillagePools;
import net.minecraft.world.gen.feature.structure.TaigaVillagePools;

public class VillageStructures {
    public static void init() {
        if (!((Boolean)APConfig.WORLD_CONFIG.ENABLE_VILLAGER_STRUCTURES.get()).booleanValue()) {
            return;
        }
        PlainsVillagePools.func_214744_a();
        SavannaVillagePools.func_214745_a();
        TaigaVillagePools.func_214806_a();
        DesertVillagePools.func_222739_a();
        SnowyVillagePools.func_214746_a();
        for (String biome : new String[]{"desert", "snowy", "plains", "savanna", "taiga"}) {
            AdvancedPeripherals.debug("Register generating scientist_" + biome + " village house");
            VillageStructures.addToPool(new ResourceLocation("village/" + biome + "/houses"), "advancedperipherals:villages/scientist_" + biome, (Integer)APConfig.WORLD_CONFIG.VILLAGER_STRUCTURE_WEIGHT.get());
        }
    }

    private static void addToPool(ResourceLocation pool, String toAdd, int weight) {
        JigsawPattern old = (JigsawPattern)WorldGenRegistries.field_243656_h.func_82594_a(pool);
        if (old == null) {
            AdvancedPeripherals.debug("no jigsaw pool for " + pool + "? skipping villager house generation for it");
            return;
        }
        List shuffled = old.func_214943_b((Random)ThreadLocalRandom.current());
        List newPieces = shuffled.stream().map(p -> Pair.of((Object)p, (Object)1)).collect(Collectors.toList());
        JigsawPiece newPiece = (JigsawPiece)JigsawPiece.func_242849_a((String)toAdd).apply(JigsawPattern.PlacementBehaviour.RIGID);
        newPieces.add(Pair.of((Object)newPiece, (Object)weight));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243656_h, (ResourceLocation)pool, (Object)new JigsawPattern(pool, old.func_214947_b(), newPieces));
        AdvancedPeripherals.debug("Finished registration for " + toAdd);
    }
}

