/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import java.util.function.BiConsumer;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ScanUtils {
    public static void relativeTraverseBlocks(World world, BlockPos center, int radius, BiConsumer<BlockState, BlockPos> consumer) {
        ScanUtils.traverseBlocks(world, center, radius, consumer, true);
    }

    public static void traverseBlocks(World world, BlockPos center, int radius, BiConsumer<BlockState, BlockPos> consumer) {
        ScanUtils.traverseBlocks(world, center, radius, consumer, false);
    }

    public static void traverseBlocks(World world, BlockPos center, int radius, BiConsumer<BlockState, BlockPos> consumer, boolean relativePosition) {
        int x = center.func_177958_n();
        int y = center.func_177956_o();
        int z = center.func_177952_p();
        for (int oX = x - radius; oX <= x + radius; ++oX) {
            for (int oY = y - radius; oY <= y + radius; ++oY) {
                for (int oZ = z - radius; oZ <= z + radius; ++oZ) {
                    BlockPos subPos = new BlockPos(oX, oY, oZ);
                    BlockState blockState = world.func_180495_p(subPos);
                    if (blockState.isAir((IBlockReader)world, subPos)) continue;
                    if (relativePosition) {
                        consumer.accept(blockState, new BlockPos(oX - x, oY - y, oZ - z));
                        continue;
                    }
                    consumer.accept(blockState, subPos);
                }
            }
        }
    }
}

