/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralTileEntity;
import de.srendi.advancedperipherals.lib.peripherals.owner.IPeripheralOwner;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;

public class DataStorageUtil {
    public static CompoundNBT getDataStorage(@Nonnull ITurtleAccess access, @Nonnull TurtleSide side) {
        return access.getUpgradeNBTData(side);
    }

    public static CompoundNBT getDataStorage(@Nonnull IPeripheralTileEntity tileEntity) {
        return tileEntity.getPeripheralSettings();
    }

    public static CompoundNBT getDataStorage(@Nonnull IPocketAccess pocket) {
        return pocket.getUpgradeNBTData();
    }

    public static class RotationCharge {
        public static final int ROTATION_STEPS = 36;
        private static final String ROTATION_CHARGE_SETTING = "rotationCharge";

        public static int get(@Nonnull ITurtleAccess access, @Nonnull TurtleSide side) {
            return DataStorageUtil.getDataStorage(access, side).func_74762_e(ROTATION_CHARGE_SETTING);
        }

        public static boolean consume(@Nonnull ITurtleAccess access, @Nonnull TurtleSide side) {
            CompoundNBT data = DataStorageUtil.getDataStorage(access, side);
            int currentCharge = data.func_74762_e(ROTATION_CHARGE_SETTING);
            if (currentCharge > 0) {
                data.func_74768_a(ROTATION_CHARGE_SETTING, Math.max(0, data.func_74762_e(ROTATION_CHARGE_SETTING) - 1));
                access.updateUpgradeNBTData(side);
                return true;
            }
            return false;
        }

        public static void addCycles(IPeripheralOwner owner, int count) {
            CompoundNBT data = owner.getDataStorage();
            data.func_74768_a(ROTATION_CHARGE_SETTING, Math.max(0, data.func_74762_e(ROTATION_CHARGE_SETTING)) + count * 36);
            owner.markDataStorageDirty();
        }
    }
}

