/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.blocks.base;

import de.srendi.advancedperipherals.common.blocks.base.PeripheralTileEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public abstract class PoweredPeripheralTileEntity<T extends BasePeripheral<?>>
extends PeripheralTileEntity<T> {
    private final LazyOptional<IEnergyStorage> lazyEnergyStorage;

    public PoweredPeripheralTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.lazyEnergyStorage = (Boolean)APConfig.PERIPHERALS_CONFIG.ENABLE_POWERED_PERIPHERALS.get() != false ? LazyOptional.of(() -> new EnergyStorage(this.getMaxEnergyStored())) : LazyOptional.empty();
    }

    protected abstract int getMaxEnergyStored();

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.lazyEnergyStorage.ifPresent(iEnergyStorage -> compound.func_74768_a("energy", iEnergyStorage.getEnergyStored()));
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        super.func_230337_a_(blockState, compound);
        this.lazyEnergyStorage.ifPresent(iEnergyStorage -> iEnergyStorage.receiveEnergy(compound.func_74762_e("energy") - iEnergyStorage.getEnergyStored(), false));
    }

    @Override
    @NotNull
    public <T1> LazyOptional<T1> getCapability(@NotNull Capability<T1> cap, @Nullable Direction direction) {
        if (cap == CapabilityEnergy.ENERGY && this.lazyEnergyStorage.isPresent()) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, direction);
    }

    @Override
    protected void invalidateCaps() {
        super.invalidateCaps();
        this.lazyEnergyStorage.invalidate();
    }
}

