/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.mekanism;

import dan200.computercraft.api.lua.LuaFunction;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.lib.peripherals.TileEntityIntegrationPeripheral;
import java.lang.reflect.Field;
import mekanism.api.math.FloatingLong;
import mekanism.common.content.network.EnergyNetwork;
import mekanism.common.tile.transmitter.TileEntityUniversalCable;
import net.minecraft.tileentity.TileEntity;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;

public class UniversalCableIntegration
extends TileEntityIntegrationPeripheral<TileEntityUniversalCable> {
    public UniversalCableIntegration(TileEntity entity) {
        super(entity);
    }

    @NotNull
    public String getType() {
        return "universalCable";
    }

    @LuaFunction(mainThread=true)
    public int getTransmitters() {
        return ((EnergyNetwork)((TileEntityUniversalCable)this.tileEntity).getTransmitter().getTransmitterNetwork()).transmittersSize();
    }

    @LuaFunction(mainThread=true)
    public int getAcceptors() {
        return ((EnergyNetwork)((TileEntityUniversalCable)this.tileEntity).getTransmitter().getTransmitterNetwork()).getAcceptorCount();
    }

    @LuaFunction(mainThread=true)
    public long getThroughput() {
        try {
            Field field = ((TileEntityUniversalCable)this.tileEntity).getClass().getDeclaredField("prevTransferAmount");
            field.setAccessible(true);
            FloatingLong throughput = (FloatingLong)field.get(this.tileEntity);
            return (long)((double)throughput.getValue() / 2.5);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            AdvancedPeripherals.debug("Could not access the throughout of the pylon! " + ex.getMessage(), Level.ERROR);
            return 0L;
        }
    }

    @LuaFunction(mainThread=true)
    public long getStored() {
        return (long)((double)((TileEntityUniversalCable)this.tileEntity).getTransmitter().buffer.getEnergy().getValue() / 2.5);
    }

    @LuaFunction(mainThread=true)
    public long getNetworkStored() {
        return (long)((double)((EnergyNetwork)((TileEntityUniversalCable)this.tileEntity).getTransmitter().getTransmitterNetwork()).getBuffer().getValue() / 2.5);
    }

    @LuaFunction(mainThread=true)
    public long getCapacity() {
        return (long)((double)((TileEntityUniversalCable)this.tileEntity).getTransmitter().getCapacity() / 2.5);
    }

    @LuaFunction(mainThread=true)
    public long getNetworkCapacity() {
        return (long)((double)((EnergyNetwork)((TileEntityUniversalCable)this.tileEntity).getTransmitter().getTransmitterNetwork()).getCapacity() / 2.5);
    }

    @LuaFunction(mainThread=true)
    public String getTier() {
        return ((TileEntityUniversalCable)this.tileEntity).getTransmitter().tier.toString();
    }
}

