/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.mekanism;

import dan200.computercraft.api.lua.LuaFunction;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.lib.peripherals.TileEntityIntegrationPeripheral;
import java.lang.reflect.Field;
import mekanism.api.math.FloatingLong;
import mekanism.common.content.network.HeatNetwork;
import mekanism.common.tile.transmitter.TileEntityThermodynamicConductor;
import net.minecraft.tileentity.TileEntity;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;

public class ThermodynamicConductorIntegration
extends TileEntityIntegrationPeripheral<TileEntityThermodynamicConductor> {
    public ThermodynamicConductorIntegration(TileEntity entity) {
        super(entity);
    }

    @NotNull
    public String getType() {
        return "universalCable";
    }

    @LuaFunction(mainThread=true)
    public int getTransmitters() {
        return ((HeatNetwork)((TileEntityThermodynamicConductor)this.tileEntity).getTransmitter().getTransmitterNetwork()).transmittersSize();
    }

    @LuaFunction(mainThread=true)
    public int getAcceptors() {
        return ((HeatNetwork)((TileEntityThermodynamicConductor)this.tileEntity).getTransmitter().getTransmitterNetwork()).getAcceptorCount();
    }

    @LuaFunction(mainThread=true)
    public long getThroughput() {
        try {
            Field field = ((TileEntityThermodynamicConductor)this.tileEntity).getClass().getDeclaredField("prevTransferAmount");
            field.setAccessible(true);
            FloatingLong throughput = (FloatingLong)field.get(this.tileEntity);
            return throughput.getValue();
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            AdvancedPeripherals.debug("Could not access the throughout of the pylon! " + ex.getMessage(), Level.ERROR);
            return 0L;
        }
    }

    @LuaFunction(mainThread=true)
    public double getStored() {
        return ((TileEntityThermodynamicConductor)this.tileEntity).getTransmitter().buffer.getHeat();
    }

    @LuaFunction(mainThread=true)
    public double getCapacity() {
        return ((TileEntityThermodynamicConductor)this.tileEntity).getTransmitter().getTotalHeatCapacity();
    }

    @LuaFunction(mainThread=true)
    public String getTier() {
        return ((TileEntityThermodynamicConductor)this.tileEntity).getTransmitter().tier.toString();
    }
}

