/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.mekanism;

import dan200.computercraft.api.lua.LuaFunction;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralPlugin;
import de.srendi.advancedperipherals.lib.peripherals.TileEntityIntegrationPeripheral;
import java.util.List;
import java.util.function.Function;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.tileentity.TileEntity;
import org.jetbrains.annotations.NotNull;

public class GenericMekanismIntegration
extends TileEntityIntegrationPeripheral<TileEntityMekanism>
implements IPeripheralPlugin {
    public GenericMekanismIntegration(TileEntity entity) {
        super(entity);
    }

    private FloatingLong getTotalEnergy(Function<IEnergyContainer, FloatingLong> getter) {
        FloatingLong total = FloatingLong.ZERO;
        List energyContainers = ((TileEntityMekanism)this.tileEntity).getEnergyContainers(null);
        for (IEnergyContainer energyContainer : energyContainers) {
            total = total.plusEqual(getter.apply(energyContainer));
        }
        return total;
    }

    @LuaFunction(mainThread=true)
    public final double getTotalEnergyFilledPercentage() {
        FloatingLong stored = FloatingLong.ZERO;
        FloatingLong max = FloatingLong.ZERO;
        List energyContainers = ((TileEntityMekanism)this.tileEntity).getEnergyContainers(null);
        for (IEnergyContainer energyContainer : energyContainers) {
            stored = stored.plusEqual(energyContainer.getEnergy());
            max = max.plusEqual(energyContainer.getMaxEnergy());
        }
        return stored.divideToLevel(max);
    }

    @LuaFunction(mainThread=true)
    public final long getTotalEnergy() {
        return EnergyCompatUtils.EnergyType.FORGE.convertToAsLong(this.getTotalEnergy(IEnergyContainer::getEnergy));
    }

    @LuaFunction(mainThread=true)
    public final long getTotalMaxEnergy() {
        return EnergyCompatUtils.EnergyType.FORGE.convertToAsLong(this.getTotalEnergy(IEnergyContainer::getMaxEnergy));
    }

    @LuaFunction(mainThread=true)
    public final long getTotalEnergyNeeded() {
        return EnergyCompatUtils.EnergyType.FORGE.convertToAsLong(this.getTotalEnergy(IEnergyContainer::getNeeded));
    }

    @NotNull
    public String getType() {
        return "mekanismMachine";
    }
}

