/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.mekanism;

import dan200.computercraft.api.lua.LuaFunction;
import de.srendi.advancedperipherals.lib.peripherals.TileEntityIntegrationPeripheral;
import java.util.HashMap;
import java.util.Map;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.content.evaporation.EvaporationMultiblockData;
import mekanism.common.tile.multiblock.TileEntityThermalEvaporationValve;
import net.minecraft.tileentity.TileEntity;
import org.jetbrains.annotations.NotNull;

public class EvaporationIntegration
extends TileEntityIntegrationPeripheral<TileEntityThermalEvaporationValve> {
    public EvaporationIntegration(TileEntity entity) {
        super(entity);
    }

    @NotNull
    public String getType() {
        return "evaporationTower";
    }

    @LuaFunction(mainThread=true)
    public final double getHeat() {
        return this.getMultiblock().getTemp();
    }

    @LuaFunction(mainThread=true)
    public final int getHeight() {
        return this.getMultiblock().height();
    }

    @LuaFunction(mainThread=true)
    public final double getProduction() {
        return (double)Math.round(this.getMultiblock().lastGain * 100.0) / 100.0;
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getInputTank() {
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        BasicFluidTank inputTank = this.getMultiblock().inputTank;
        result.put("name", inputTank.getFluidAmount() > 0 ? inputTank.getFluid().getFluid().getRegistryName().toString() : null);
        result.put("amount", inputTank.getFluidAmount());
        return result;
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getOutputTank() {
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        BasicFluidTank outputTank = this.getMultiblock().outputTank;
        result.put("name", outputTank.getFluidAmount() > 0 ? outputTank.getFluid().getFluid().getRegistryName().toString() : null);
        result.put("amount", outputTank.getFluidAmount());
        return result;
    }

    private EvaporationMultiblockData getMultiblock() {
        return (EvaporationMultiblockData)((TileEntityThermalEvaporationValve)this.tileEntity).getMultiblock();
    }
}

