/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.mekanism;

import dan200.computercraft.api.lua.LuaFunction;
import de.srendi.advancedperipherals.lib.peripherals.TileEntityIntegrationPeripheral;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.math.MathUtils;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.boiler.BoilerMultiblockData;
import mekanism.common.tile.multiblock.TileEntityBoilerValve;
import mekanism.common.util.HeatUtils;
import net.minecraft.tileentity.TileEntity;

public class BoilerIntegration
extends TileEntityIntegrationPeripheral<TileEntityBoilerValve> {
    public BoilerIntegration(TileEntity entity) {
        super(entity);
    }

    public String getType() {
        return "boiler";
    }

    @LuaFunction(mainThread=true)
    public final int getWater() {
        return this.getBoiler().waterTank.getFluidAmount();
    }

    @LuaFunction(mainThread=true)
    public final int getWaterCapacity() {
        return this.getBoiler().waterTank.getCapacity();
    }

    @LuaFunction(mainThread=true)
    public final int getWaterNeeded() {
        return this.getBoiler().waterTank.getNeeded();
    }

    @LuaFunction(mainThread=true)
    public final double getWaterFilledPercentage() {
        return (double)this.getWater() / (double)this.getWaterCapacity();
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getHeatedCoolant() {
        ChemicalStack stack = this.getBoiler().superheatedCoolantTank.getStack();
        HashMap<String, Object> wrapped = new HashMap<String, Object>(2);
        wrapped.put("name", stack.getType().getRegistryName() == null ? null : stack.getType().getRegistryName().toString());
        wrapped.put("amount", stack.getAmount());
        return wrapped;
    }

    @LuaFunction(mainThread=true)
    public final long getHeatedCoolantCapacity() {
        return this.getBoiler().superheatedCoolantTank.getCapacity();
    }

    @LuaFunction(mainThread=true)
    public final long getHeatedCoolantNeeded() {
        return this.getBoiler().superheatedCoolantTank.getNeeded();
    }

    @LuaFunction(mainThread=true)
    public final double getHeatedCoolantFilledPercentage() {
        return (double)this.getBoiler().superheatedCoolantTank.getStored() / (double)this.getHeatedCoolantCapacity();
    }

    @LuaFunction(mainThread=true)
    public final long getSteam() {
        return this.getBoiler().steamTank.getStored();
    }

    @LuaFunction(mainThread=true)
    public final long getSteamCapacity() {
        return this.getBoiler().steamTank.getCapacity();
    }

    @LuaFunction(mainThread=true)
    public final long getSteamNeeded() {
        return this.getBoiler().steamTank.getNeeded();
    }

    @LuaFunction(mainThread=true)
    public final double getSteamFilledPercentage() {
        return (double)this.getSteam() / (double)this.getSteamCapacity();
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getCooledCoolant() {
        ChemicalStack stack = this.getBoiler().cooledCoolantTank.getStack();
        HashMap<String, Object> wrapped = new HashMap<String, Object>(2);
        wrapped.put("name", stack.getType().getRegistryName() == null ? null : stack.getType().getRegistryName().toString());
        wrapped.put("amount", stack.getAmount());
        return wrapped;
    }

    @LuaFunction(mainThread=true)
    public final long getCooledCoolantCapacity() {
        return this.getBoiler().cooledCoolantTank.getCapacity();
    }

    @LuaFunction(mainThread=true)
    public final long getCooledCoolantNeeded() {
        return this.getBoiler().cooledCoolantTank.getNeeded();
    }

    @LuaFunction(mainThread=true)
    public final double getCooledCoolantFilledPercentage() {
        return (double)((GasStack)this.getBoiler().cooledCoolantTank.getStack()).getAmount() / (double)this.getCooledCoolantCapacity();
    }

    @LuaFunction(mainThread=true)
    public final double getEnvironmentalLoss() {
        return this.getBoiler().lastEnvironmentLoss;
    }

    @LuaFunction(mainThread=true)
    public final double getTemperature() {
        return this.getBoiler().getTotalTemperature();
    }

    @LuaFunction(mainThread=true)
    public final int getBoilRate() {
        return this.getBoiler().lastBoilRate;
    }

    @LuaFunction(mainThread=true)
    public final int getMaxBoilRate() {
        return this.getBoiler().lastMaxBoil;
    }

    @LuaFunction(mainThread=true)
    public final int getSuperheaters() {
        return this.getBoiler().superheatingElements;
    }

    @LuaFunction(mainThread=true)
    public final long getBoilCapacity() {
        double boilCapacity = MekanismConfig.general.superheatingHeatTransfer.get() * (double)this.getSuperheaters() / HeatUtils.getWaterThermalEnthalpy();
        return MathUtils.clampToLong((double)(boilCapacity * HeatUtils.getSteamEnergyEfficiency()));
    }

    private BoilerMultiblockData getBoiler() {
        return (BoilerMultiblockData)((TileEntityBoilerValve)this.tileEntity).getMultiblock();
    }
}

