/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.draconicevolution;

import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorComponent;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorStabilizer;
import dan200.computercraft.api.lua.LuaFunction;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.lib.peripherals.TileEntityIntegrationPeripheral;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import org.apache.logging.log4j.Level;

public class ReactorIntegration
extends TileEntityIntegrationPeripheral<TileReactorStabilizer> {
    public ReactorIntegration(TileEntity entity) {
        super(entity);
    }

    @Nonnull
    public String getType() {
        return "draconic_reactor";
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getReactorInfo() {
        TileReactorCore reactor = this.getCore();
        if (reactor == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("temperature", MathUtils.round((double)reactor.temperature.get(), (double)100.0));
        map.put("fieldStrength", MathUtils.round((double)reactor.shieldCharge.get(), (double)100.0));
        map.put("maxFieldStrength", MathUtils.round((double)reactor.maxShieldCharge.get(), (double)100.0));
        map.put("energySaturation", reactor.saturation.get());
        map.put("maxEnergySaturation", reactor.maxSaturation.get());
        map.put("fuelConversion", MathUtils.round((double)reactor.convertedFuel.get(), (double)1000.0));
        map.put("maxFuelConversion", reactor.reactableFuel.get() + reactor.convertedFuel.get());
        map.put("generationRate", (int)reactor.generationRate.get());
        map.put("fieldDrainRate", reactor.fieldDrain.get());
        map.put("fuelConversionRate", (int)Math.round(reactor.fuelUseRate.get() * 1000000.0));
        map.put("status", ((TileReactorCore.ReactorState)reactor.reactorState.get()).name().toLowerCase(Locale.ENGLISH));
        map.put("failSafe", reactor.failSafeMode.get());
        return map;
    }

    @LuaFunction(mainThread=true)
    public final boolean chargeReactor() {
        TileReactorCore reactor = this.getCore();
        if (reactor.canCharge()) {
            reactor.chargeReactor();
            return true;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final boolean activateReactor() {
        TileReactorCore reactor = this.getCore();
        if (reactor.canActivate()) {
            reactor.activateReactor();
            return true;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final boolean stopReactor() {
        TileReactorCore reactor = this.getCore();
        if (reactor.canStop()) {
            reactor.shutdownReactor();
            return true;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final void setFailSafe(boolean failSafe) {
        TileReactorCore reactor = this.getCore();
        reactor.failSafeMode.set(failSafe);
    }

    private TileReactorCore getCore() {
        try {
            Method method = TileReactorComponent.class.getDeclaredMethod("getCachedCore", new Class[0]);
            method.setAccessible(true);
            return (TileReactorCore)method.invoke((Object)this.tileEntity, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            AdvancedPeripherals.debug("Could not access the reactor of the stabilizer! " + ex, Level.ERROR);
            return null;
        }
    }
}

