/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins.AutomataCorePlugin;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.lib.peripherals.AutomataCorePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.owner.FuelAbility;
import de.srendi.advancedperipherals.lib.peripherals.owner.PeripheralOwnerAbility;
import de.srendi.advancedperipherals.lib.peripherals.owner.TurtlePeripheralOwner;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;

public class AutomataChargingPlugin
extends AutomataCorePlugin {
    public AutomataChargingPlugin(AutomataCorePeripheral automataCore) {
        super(automataCore);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult chargeTurtle(@Nonnull IArguments arguments) throws LuaException {
        TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.automataCore.getPeripheralOwner();
        FuelAbility<?> fuelAbility = owner.getAbility(PeripheralOwnerAbility.FUEL);
        Objects.requireNonNull(fuelAbility);
        if (fuelAbility.isFuelConsumptionDisable()) {
            return MethodResult.of((Object[])new Object[]{null, "Fuel consumption is disabled, why do you even need this?"});
        }
        ItemStack stack = owner.getToolInMainHand();
        int fuel = arguments.optInt(0, -1);
        return stack.getCapability(CapabilityEnergy.ENERGY).map(storage -> {
            int availableFuelSpace = fuelAbility.getFuelMaxCount() - fuelAbility.getFuelCount();
            int requestedRF = fuel != -1 ? fuel * (Integer)APConfig.METAPHYSICS_CONFIG.ENERGY_TO_FUEL_RATE.get() : storage.getEnergyStored();
            int realConsumedRF = storage.extractEnergy(Math.min(requestedRF, availableFuelSpace * (Integer)APConfig.METAPHYSICS_CONFIG.ENERGY_TO_FUEL_RATE.get()), false);
            int receivedFuel = realConsumedRF / (Integer)APConfig.METAPHYSICS_CONFIG.ENERGY_TO_FUEL_RATE.get();
            fuelAbility.addFuel(receivedFuel);
            this.automataCore.addRotationCycle();
            return MethodResult.of((Object[])new Object[]{true, receivedFuel});
        }).orElse(MethodResult.of((Object[])new Object[]{null, "Item should provide energy ..."}));
    }
}

