/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralTileEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.owner.IPeripheralOwner;
import de.srendi.advancedperipherals.lib.peripherals.owner.PocketPeripheralOwner;
import de.srendi.advancedperipherals.lib.peripherals.owner.TileEntityPeripheralOwner;
import de.srendi.advancedperipherals.lib.peripherals.owner.TurtlePeripheralOwner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PlayerDetectorPeripheral
extends BasePeripheral<IPeripheralOwner> {
    public static final String TYPE = "playerDetector";

    public PlayerDetectorPeripheral(PeripheralTileEntity<?> tileEntity) {
        super(TYPE, new TileEntityPeripheralOwner(tileEntity));
    }

    public PlayerDetectorPeripheral(ITurtleAccess access, TurtleSide side) {
        super(TYPE, new TurtlePeripheralOwner(access, side));
    }

    public PlayerDetectorPeripheral(IPocketAccess pocket) {
        super(TYPE, new PocketPeripheralOwner(pocket));
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.ENABLE_PLAYER_DETECTOR.get();
    }

    @LuaFunction(mainThread=true)
    public final String[] getOnlinePlayers() {
        return ServerLifecycleHooks.getCurrentServer().func_71213_z();
    }

    @LuaFunction(mainThread=true)
    public final List<String> getPlayersInCoords(Map<?, ?> firstCoord, Map<?, ?> secondCoord) throws LuaException {
        ArrayList<String> playersName = new ArrayList<String>();
        BlockPos firstPos = LuaConverter.convertToBlockPos(firstCoord);
        BlockPos secondPos = LuaConverter.convertToBlockPos(secondCoord);
        for (ServerPlayerEntity player : this.getPlayers()) {
            if (!this.isInRange((PlayerEntity)player, firstPos, secondPos)) continue;
            playersName.add(player.func_200200_C_().getString());
        }
        return playersName;
    }

    @LuaFunction(mainThread=true)
    public final List<String> getPlayersInCubic(int x, int y, int z) {
        ArrayList<String> playersName = new ArrayList<String>();
        for (ServerPlayerEntity player : this.getPlayers()) {
            if (!this.isInRange(this.getPos(), (PlayerEntity)player, x, y, z)) continue;
            playersName.add(player.func_200200_C_().getString());
        }
        return playersName;
    }

    @LuaFunction(mainThread=true)
    public final List<String> getPlayersInRange(int range) {
        ArrayList<String> playersName = new ArrayList<String>();
        for (ServerPlayerEntity player : this.getPlayers()) {
            if (!this.isInRange(this.getPos(), (PlayerEntity)player, range)) continue;
            playersName.add(player.func_200200_C_().getString());
        }
        return playersName;
    }

    @LuaFunction(mainThread=true)
    public final boolean isPlayersInCoords(Map<?, ?> firstCoord, Map<?, ?> secondCoord) throws LuaException {
        if (this.getPlayers().isEmpty()) {
            return false;
        }
        BlockPos firstPos = LuaConverter.convertToBlockPos(firstCoord);
        BlockPos secondPos = LuaConverter.convertToBlockPos(secondCoord);
        for (ServerPlayerEntity player : this.getPlayers()) {
            if (!this.isInRange((PlayerEntity)player, firstPos, secondPos)) continue;
            return true;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final boolean isPlayersInCubic(int x, int y, int z) {
        if (this.getPlayers().isEmpty()) {
            return false;
        }
        for (ServerPlayerEntity player : this.getPlayers()) {
            if (!this.isInRange(this.getPos(), (PlayerEntity)player, x, y, z)) continue;
            return true;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final boolean isPlayersInRange(int range) {
        if (this.getPlayers().isEmpty()) {
            return false;
        }
        for (ServerPlayerEntity player : this.getPlayers()) {
            if (!this.isInRange(this.getPos(), (PlayerEntity)player, range)) continue;
            return true;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final boolean isPlayerInCoords(Map<?, ?> firstCoord, Map<?, ?> secondCoord, String username) throws LuaException {
        ArrayList<String> playersName = new ArrayList<String>();
        BlockPos firstPos = LuaConverter.convertToBlockPos(firstCoord);
        BlockPos secondPos = LuaConverter.convertToBlockPos(secondCoord);
        for (PlayerEntity playerEntity : this.getPlayers()) {
            if (!this.isInRange(playerEntity, firstPos, secondPos)) continue;
            playersName.add(playerEntity.func_200200_C_().getString());
        }
        return playersName.contains(username);
    }

    @LuaFunction(mainThread=true)
    public final boolean isPlayerInCubic(int x, int y, int z, String username) {
        ArrayList<String> playersName = new ArrayList<String>();
        for (PlayerEntity playerEntity : this.getPlayers()) {
            if (!this.isInRange(this.getPos(), playerEntity, x, y, z)) continue;
            playersName.add(playerEntity.func_200200_C_().getString());
        }
        return playersName.contains(username);
    }

    @LuaFunction(mainThread=true)
    public final boolean isPlayerInRange(int range, String username) {
        ArrayList<String> playersName = new ArrayList<String>();
        for (PlayerEntity playerEntity : this.getPlayers()) {
            if (!this.isInRange(this.getPos(), playerEntity, range)) continue;
            playersName.add(playerEntity.func_200200_C_().getString());
        }
        return playersName.contains(username);
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getPlayerPos(String username) throws LuaException {
        if (!((Boolean)APConfig.PERIPHERALS_CONFIG.PLAYER_SPY.get()).booleanValue()) {
            throw new LuaException("This function is disabled in the config. Activate it or ask an admin if he can activate it.");
        }
        ServerPlayerEntity existingPlayer = null;
        for (ServerPlayerEntity player : this.getPlayers()) {
            if (!player.func_200200_C_().getString().equals(username) || !this.isInRange(this.getPos(), (PlayerEntity)player, (Integer)APConfig.PERIPHERALS_CONFIG.PLAYER_DET_MAX_RANGE.get())) continue;
            existingPlayer = player;
            break;
        }
        if (existingPlayer == null) {
            return null;
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("x", Math.floor(existingPlayer.func_226277_ct_()));
        info.put("y", Math.floor(existingPlayer.func_226278_cu_()));
        info.put("z", Math.floor(existingPlayer.func_226281_cx_()));
        if (((Boolean)APConfig.PERIPHERALS_CONFIG.MORE_PLAYER_INFORMATION.get()).booleanValue()) {
            info.put("yaw", Float.valueOf(existingPlayer.field_70177_z));
            info.put("pitch", Float.valueOf(existingPlayer.field_70125_A));
            info.put("dimension", existingPlayer.func_71121_q().func_234923_W_().func_240901_a_().toString());
            info.put("eyeHeight", Float.valueOf(existingPlayer.func_70047_e()));
        }
        return info;
    }

    private List<ServerPlayerEntity> getPlayers() {
        return ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
    }

    private boolean isInRange(BlockPos pos, PlayerEntity player, int range) {
        World world = this.getWorld();
        return world.func_217373_a(new EntityPredicate().func_221008_a().func_221009_d().func_221014_c().func_221011_b(), null, new AxisAlignedBB(pos.func_177982_a(range, range, range), pos.func_177982_a(-range, -range, -range))).contains(player);
    }

    private boolean isInRange(BlockPos pos, PlayerEntity player, int x, int y, int z) {
        World world = this.getWorld();
        return world.func_217373_a(new EntityPredicate().func_221008_a().func_221009_d().func_221014_c().func_221011_b(), null, new AxisAlignedBB(pos.func_177982_a(x, y, z), pos.func_177982_a(-x, -y, -z))).contains(player);
    }

    private boolean isInRange(PlayerEntity player, BlockPos firstPos, BlockPos secondPos) {
        World world = this.getWorld();
        return world.func_217373_a(new EntityPredicate().func_221008_a().func_221009_d().func_221014_c().func_221011_b(), null, new AxisAlignedBB(firstPos, secondPos)).contains(player);
    }
}

