/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.blocks.tileentity.InventoryManagerTile;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.InventoryUtil;
import de.srendi.advancedperipherals.common.util.ItemUtil;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.owner.TileEntityPeripheralOwner;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public class InventoryManagerPeripheral
extends BasePeripheral<TileEntityPeripheralOwner<InventoryManagerTile>> {
    public static final String TYPE = "inventoryManager";

    public InventoryManagerPeripheral(InventoryManagerTile tileEntity) {
        super(TYPE, new TileEntityPeripheralOwner<InventoryManagerTile>(tileEntity));
    }

    private static int getArmorSlot(int index) {
        switch (index) {
            case 103: {
                return 3;
            }
            case 102: {
                return 2;
            }
            case 101: {
                return 1;
            }
            case 100: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.ENABLE_INVENTORY_MANAGER.get();
    }

    @LuaFunction
    public final String getOwner() throws LuaException {
        if (this.getOwnerPlayer() == null) {
            return null;
        }
        return this.getOwnerPlayer().func_200200_C_().getString();
    }

    @LuaFunction(mainThread=true, value={"pullItems", "addItemToPlayer"})
    public final int addItemToPlayer(String invDirection, int count, Optional<Integer> slot, Optional<String> item) throws LuaException {
        ItemStack stack = ItemStack.field_190927_a;
        if (item.isPresent()) {
            Item item1 = (Item)ItemUtil.getRegistryEntry(item.get(), ForgeRegistries.ITEMS);
            stack = new ItemStack((IItemProvider)item1, count);
        }
        Direction direction = this.validateSide(invDirection);
        TileEntity targetEntity = ((TileEntityPeripheralOwner)this.owner).getWorld().func_175625_s(((TileEntityPeripheralOwner)this.owner).getPos().func_177972_a(direction));
        IItemHandler inventoryFrom = targetEntity != null ? (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).resolve().orElse(null) : null;
        PlayerInvWrapper inventoryTo = new PlayerInvWrapper(this.getOwnerPlayer().field_71071_by);
        int invSlot = slot.orElse(0);
        if (inventoryFrom == null) {
            return 0;
        }
        int amount = count;
        int transferableAmount = 0;
        for (int i = 0; i < inventoryFrom.getSlots() && amount > 0; ++i) {
            if (stack.func_190926_b() && (stack = inventoryFrom.getStackInSlot(i).func_77946_l()).func_190926_b() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)inventoryFrom.getStackInSlot(i))) continue;
            if (invSlot >= 100 && invSlot < 104) {
                if (!(stack.func_77973_b() instanceof ArmorItem)) {
                    throw new LuaException(stack + "is not an armor item. Can't put it into the slot " + invSlot);
                }
                if (!((ItemStack)this.getOwnerPlayer().field_71071_by.field_70460_b.get(InventoryManagerPeripheral.getArmorSlot(invSlot))).func_190926_b()) continue;
                this.getOwnerPlayer().field_71071_by.field_70460_b.set(InventoryManagerPeripheral.getArmorSlot(invSlot), (Object)stack);
                inventoryFrom.extractItem(i, 1, false);
                transferableAmount = 1;
                continue;
            }
            int inserted = InventoryUtil.moveItem(inventoryFrom, i, (IItemHandler)inventoryTo, invSlot, amount);
            transferableAmount += inserted;
            amount -= inserted;
            inserted = InventoryUtil.moveItem(inventoryFrom, i, (IItemHandler)inventoryTo, -1, amount);
            transferableAmount += inserted;
            amount -= inserted;
        }
        return transferableAmount;
    }

    @LuaFunction(mainThread=true, value={"pushItems", "removeItemFromPlayer"})
    public final int removeItemFromPlayer(String invDirection, int count, Optional<Integer> slot, Optional<String> item) throws LuaException {
        IItemHandler inventoryTo;
        ItemStack stack = ItemStack.field_190927_a;
        if (item.isPresent()) {
            Item item1 = (Item)ItemUtil.getRegistryEntry(item.get(), ForgeRegistries.ITEMS);
            stack = new ItemStack((IItemProvider)item1, count);
        }
        int invSlot = -1;
        if (slot.isPresent() && slot.get() > 0) {
            invSlot = slot.get();
        }
        Direction direction = this.validateSide(invDirection);
        TileEntity targetEntity = ((TileEntityPeripheralOwner)this.owner).getWorld().func_175625_s(((TileEntityPeripheralOwner)this.owner).getPos().func_177972_a(direction));
        PlayerInventory inventoryFrom = this.getOwnerPlayer().field_71071_by;
        IItemHandler iItemHandler = inventoryTo = targetEntity != null ? (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).resolve().orElse(null) : null;
        if (inventoryTo == null) {
            return 0;
        }
        int amount = count;
        int transferableAmount = 0;
        ItemStack rest = ItemStack.field_190927_a;
        if (invSlot == -1) {
            for (int i = 0; i < inventoryFrom.func_70302_i_(); ++i) {
                int subcount;
                if (!stack.func_190926_b() && inventoryFrom.func_70301_a(i).func_77969_a(stack)) {
                    if (inventoryFrom.func_70301_a(i).func_190916_E() >= amount) {
                        rest = this.insertItem(inventoryTo, inventoryFrom.func_70298_a(i, amount));
                        transferableAmount += amount - rest.func_190916_E();
                        break;
                    }
                    subcount = inventoryFrom.func_70301_a(i).func_190916_E();
                    rest = this.insertItem(inventoryTo, inventoryFrom.func_70298_a(i, subcount));
                    amount = count - subcount;
                    transferableAmount += subcount - rest.func_190916_E();
                    if (!rest.func_190926_b()) break;
                }
                if (!stack.func_190926_b()) continue;
                if (inventoryFrom.func_70301_a(i).func_190916_E() >= amount) {
                    rest = this.insertItem(inventoryTo, inventoryFrom.func_70298_a(i, amount));
                    transferableAmount += amount - rest.func_190916_E();
                    break;
                }
                subcount = inventoryFrom.func_70301_a(i).func_190916_E();
                rest = this.insertItem(inventoryTo, inventoryFrom.func_70298_a(i, subcount));
                amount = count - subcount;
                transferableAmount += subcount - rest.func_190916_E();
                if (!rest.func_190926_b()) break;
            }
        }
        if (invSlot != -1) {
            int subcount;
            if (!stack.func_190926_b() && inventoryFrom.func_70301_a(slot.get().intValue()).func_77969_a(stack)) {
                if (inventoryFrom.func_70301_a(slot.get().intValue()).func_190916_E() >= amount) {
                    rest = this.insertItem(inventoryTo, inventoryFrom.func_70298_a(slot.get().intValue(), amount));
                    transferableAmount += amount - rest.func_190916_E();
                } else {
                    subcount = inventoryFrom.func_70301_a(slot.get().intValue()).func_190916_E();
                    rest = this.insertItem(inventoryTo, inventoryFrom.func_70298_a(slot.get().intValue(), subcount));
                    transferableAmount += subcount - rest.func_190916_E();
                }
            }
            if (stack.func_190926_b()) {
                if (inventoryFrom.func_70301_a(slot.get().intValue()).func_190916_E() >= amount) {
                    rest = this.insertItem(inventoryTo, inventoryFrom.func_70298_a(slot.get().intValue(), amount));
                    transferableAmount += amount - rest.func_190916_E();
                } else {
                    subcount = inventoryFrom.func_70301_a(slot.get().intValue()).func_190916_E();
                    rest = this.insertItem(inventoryTo, inventoryFrom.func_70298_a(slot.get().intValue(), subcount));
                    transferableAmount += subcount - rest.func_190916_E();
                }
            }
        }
        if (!rest.func_190926_b()) {
            inventoryFrom.func_70441_a(rest);
        }
        return transferableAmount;
    }

    @Nonnull
    @LuaFunction(value={"list", "getItems"}, mainThread=true)
    public final Map<Integer, Object> getItems() throws LuaException {
        HashMap<Integer, Object> items = new HashMap<Integer, Object>();
        int i = 0;
        for (ItemStack stack : this.getOwnerPlayer().field_71071_by.field_70462_a) {
            if (!stack.func_190926_b()) {
                items.put(i, LuaConverter.stackToObject(stack));
            }
            ++i;
        }
        return items;
    }

    @LuaFunction(mainThread=true)
    public final Map<Integer, Object> getArmor() throws LuaException {
        HashMap<Integer, Object> items = new HashMap<Integer, Object>();
        int i = 0;
        for (ItemStack stack : this.getOwnerPlayer().field_71071_by.field_70460_b) {
            AdvancedPeripherals.debug("DEBUG1 " + i);
            if (!stack.func_190926_b()) {
                items.put(ArmorSlot.getSlotForItem(stack), LuaConverter.stackToObject(stack));
            }
            ++i;
        }
        return items;
    }

    @LuaFunction(mainThread=true)
    public final boolean isPlayerEquipped() throws LuaException {
        for (ItemStack stack : this.getOwnerPlayer().field_71071_by.field_70460_b) {
            if (stack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final boolean isWearing(int index) throws LuaException {
        int i = 0;
        for (ItemStack stack : this.getOwnerPlayer().field_71071_by.field_70460_b) {
            if (stack.func_190926_b()) continue;
            if (index == i) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final int getEmptySpace() throws LuaException {
        int i = 0;
        for (ItemStack stack : this.getOwnerPlayer().field_71071_by.field_70462_a) {
            if (!stack.func_190926_b()) continue;
            ++i;
        }
        return i;
    }

    @LuaFunction(mainThread=true)
    public final boolean isSpaceAvailable() throws LuaException {
        return this.getEmptySpace() > 0;
    }

    @LuaFunction(mainThread=true)
    public final int getFreeSlot() throws LuaException {
        return this.getOwnerPlayer().field_71071_by.func_70447_i();
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getItemInHand() throws LuaException {
        return LuaConverter.stackToObject(this.getOwnerPlayer().field_71071_by.func_70448_g());
    }

    private PlayerEntity getOwnerPlayer() throws LuaException {
        if (((TileEntityPeripheralOwner)this.owner).getOwner() == null) {
            throw new LuaException("The Inventory Manager doesn't have a memory card or it isn't bound to a player.");
        }
        return ((TileEntityPeripheralOwner)this.owner).getOwner();
    }

    private ItemStack insertItem(IItemHandler inventoryTo, ItemStack stack) {
        for (int i = 0; i < inventoryTo.getSlots() && !stack.func_190926_b(); ++i) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(null);
            }
            stack = inventoryTo.insertItem(i, stack, false);
        }
        return stack;
    }

    private static enum ArmorSlot {
        HELMET_SLOT(103, EquipmentSlotType.HEAD),
        CHEST_SLOT(102, EquipmentSlotType.CHEST),
        LEGGINGS_SLOT(101, EquipmentSlotType.LEGS),
        BOOTS_SLOT(100, EquipmentSlotType.FEET);

        private final int slot;
        private final EquipmentSlotType slotType;

        private ArmorSlot(int slot, EquipmentSlotType slotType) {
            this.slot = slot;
            this.slotType = slotType;
        }

        public static int getSlotForItem(ItemStack stack) {
            if (stack.func_77973_b() instanceof ArmorItem) {
                for (ArmorSlot slot : ArmorSlot.values()) {
                    if (((ArmorItem)stack.func_77973_b()).func_185083_B_() != slot.slotType) continue;
                    return slot.slot;
                }
            }
            AdvancedPeripherals.LOGGER.warn("Tried to get armor item slot for non armor item " + stack + ". Returning 0");
            return 0;
        }

        public int getSlot() {
            return this.slot;
        }
    }
}

