/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SphereOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SphereOperationContext;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralTileEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.common.util.ScanUtils;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.owner.IPeripheralOwner;
import de.srendi.advancedperipherals.lib.peripherals.owner.PocketPeripheralOwner;
import de.srendi.advancedperipherals.lib.peripherals.owner.TileEntityPeripheralOwner;
import de.srendi.advancedperipherals.lib.peripherals.owner.TurtlePeripheralOwner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.Tags;

public class GeoScannerPeripheral
extends BasePeripheral<IPeripheralOwner> {
    public static final String TYPE = "geoScanner";

    protected GeoScannerPeripheral(IPeripheralOwner owner) {
        super(TYPE, owner);
        owner.attachOperation(SphereOperation.SCAN_BLOCKS);
    }

    public GeoScannerPeripheral(PeripheralTileEntity<?> tileEntity) {
        this(new TileEntityPeripheralOwner(tileEntity).attachFuel());
    }

    public GeoScannerPeripheral(ITurtleAccess turtle, TurtleSide side) {
        this(new TurtlePeripheralOwner(turtle, side).attachFuel(1));
    }

    public GeoScannerPeripheral(IPocketAccess pocket) {
        this(new PocketPeripheralOwner(pocket));
    }

    private static List<Map<String, ?>> scan(World world, BlockPos center, int radius) {
        ArrayList result = new ArrayList();
        ScanUtils.relativeTraverseBlocks(world, center, radius, (state, pos) -> {
            HashMap<String, Object> data = new HashMap<String, Object>(6);
            data.put("x", pos.func_177958_n());
            data.put("y", pos.func_177956_o());
            data.put("z", pos.func_177952_p());
            Block block = state.func_177230_c();
            ResourceLocation name = block.getRegistryName();
            data.put("name", name == null ? "unknown" : name.toString());
            data.put("tags", LuaConverter.tagsToList(block.getTags()));
            result.add(data);
        });
        return result;
    }

    private static int estimateCost(int radius) {
        if (radius > SphereOperation.SCAN_BLOCKS.getMaxCostRadius()) {
            return -1;
        }
        return SphereOperation.SCAN_BLOCKS.getCost(SphereOperationContext.of(radius));
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.ENABLE_GEO_SCANNER.get();
    }

    @LuaFunction
    public final MethodResult cost(int radius) {
        int estimatedCost = GeoScannerPeripheral.estimateCost(radius);
        if (estimatedCost < 0) {
            return MethodResult.of((Object[])new Object[]{null, "Radius is exceed max value"});
        }
        return MethodResult.of((Object)estimatedCost);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult chunkAnalyze() throws LuaException {
        return this.withOperation(SphereOperation.SCAN_BLOCKS, SphereOperation.SCAN_BLOCKS.free(), null, ignored -> {
            World world = this.getWorld();
            Chunk chunk = world.func_175726_f(this.getPos());
            ChunkPos chunkPos = chunk.func_76632_l();
            HashMap<String, Integer> data = new HashMap<String, Integer>();
            for (int x = chunkPos.func_180334_c(); x <= chunkPos.func_180332_e(); ++x) {
                for (int z = chunkPos.func_180333_d(); z <= chunkPos.func_180330_f(); ++z) {
                    for (int y = 0; y < 256; ++y) {
                        BlockState block = chunk.func_180495_p(new BlockPos(x, y, z));
                        ResourceLocation name = block.func_177230_c().getRegistryName();
                        if (name == null || !block.func_177230_c().func_203417_a((ITag)Tags.Blocks.ORES)) continue;
                        data.put(name.toString(), data.getOrDefault(name.toString(), 0) + 1);
                    }
                }
            }
            return MethodResult.of(data);
        }, null);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult scan(@Nonnull IArguments arguments) throws LuaException {
        int radius = arguments.getInt(0);
        return this.withOperation(SphereOperation.SCAN_BLOCKS, new SphereOperationContext(radius), context -> {
            if (context.getRadius() > SphereOperation.SCAN_BLOCKS.getMaxCostRadius()) {
                return MethodResult.of((Object[])new Object[]{null, "Radius is exceed max value"});
            }
            return null;
        }, context -> MethodResult.of(GeoScannerPeripheral.scan(this.getWorld(), this.getPos(), context.getRadius())), null);
    }
}

