/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.integrations;

import dan200.computercraft.api.peripheral.IPeripheral;
import de.srendi.advancedperipherals.lib.integrations.IPeripheralIntegration;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class TileEntityIntegration
implements IPeripheralIntegration {
    private static final int DEFAULT_PRIORITY = 50;
    private final Function<TileEntity, ? extends IPeripheral> build;
    private final Predicate<TileEntity> predicate;
    private final int priority;

    public TileEntityIntegration(Function<TileEntity, ? extends IPeripheral> build, Predicate<TileEntity> predicate, int priority) {
        this.build = build;
        this.predicate = predicate;
        this.priority = priority;
    }

    public TileEntityIntegration(Function<TileEntity, ? extends IPeripheral> build, Predicate<TileEntity> predicate) {
        this(build, predicate, 50);
    }

    @Override
    public boolean isSuitable(@NotNull World world, @NotNull BlockPos blockPos, @NotNull Direction direction) {
        TileEntity te = world.func_175625_s(blockPos);
        if (te == null) {
            return false;
        }
        return this.predicate.test(te);
    }

    @Override
    @NotNull
    public IPeripheral buildPeripheral(@NotNull World world, @NotNull BlockPos blockPos, @NotNull Direction direction) {
        TileEntity te = world.func_175625_s(blockPos);
        if (te == null) {
            throw new IllegalArgumentException("This should not happen");
        }
        return this.build.apply(te);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

