/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.appliedenergistics;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingCallback;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import dan200.computercraft.api.lua.ILuaCallback;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.AppEngApi;
import de.srendi.advancedperipherals.common.util.ServerWorker;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftJob
implements ICraftingCallback,
ILuaCallback {
    public static final String EVENT = "crafting";
    private final IComputerAccess computer;
    private final IGridNode node;
    private final IActionSource source;
    private final ItemStack item;
    private final World world;
    private MethodResult result;
    private LuaException exception;

    public CraftJob(World world, IComputerAccess computer, IGridNode node, ItemStack item, IActionSource source) {
        this.computer = computer;
        this.node = node;
        this.world = world;
        this.source = source;
        this.item = item;
    }

    protected void fireEvent(@Nullable ICraftingJob job, @Nullable String exception) {
        if (exception != null) {
            this.result = MethodResult.of((Object[])new Object[]{null, exception});
            this.exception = new LuaException(exception);
            this.computer.queueEvent(EVENT, new Object[]{null, exception});
        } else if (job != null) {
            this.result = MethodResult.of((Object)AppEngApi.getInstance().getObjectFromJob(job));
            this.computer.queueEvent(EVENT, new Object[]{null});
        } else {
            throw new IllegalArgumentException("job or exception should be not null!");
        }
    }

    protected void fireNotConnected() {
        this.fireEvent(null, "not connected");
    }

    public void startCrafting() {
        IGrid grid = this.node.getGrid();
        if (grid == null) {
            this.fireNotConnected();
            return;
        }
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        ICraftingGrid crafting = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
        IMEMonitor monitor = storage.getInventory(AppEngApi.getInstance().getApi().storage().getStorageChannel(IItemStorageChannel.class));
        ItemStack itemstack = this.item;
        IAEItemStack aeItem = AppEngApi.getInstance().findAEStackFromItemStack((IMEMonitor<IAEItemStack>)monitor, itemstack);
        if (aeItem == null) {
            this.fireEvent(null, this.item.func_77977_a() + " does not exists in the me system");
            return;
        }
        if (!aeItem.isCraftable()) {
            this.fireEvent(null, this.item.func_77977_a() + " is not craftable");
            return;
        }
        aeItem.setStackSize((long)itemstack.func_190916_E());
        crafting.beginCraftingJob(this.world, grid, this.source, aeItem, (ICraftingCallback)this);
    }

    public void calculationComplete(ICraftingJob job) {
        ServerWorker.add(() -> this.calcComplete(job));
    }

    private void calcComplete(ICraftingJob job) {
        if (job.isSimulation()) {
            this.fireEvent(null, "the me system has no ingredients for the crafting job");
            return;
        }
        IGrid grid = this.node.getGrid();
        if (grid == null) {
            this.fireNotConnected();
            return;
        }
        ICraftingGrid crafting = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
        ICraftingLink link = crafting.submitJob(job, null, null, false, this.source);
        if (link == null) {
            this.fireEvent(null, "an unexpected error has occurred");
        } else {
            this.fireEvent(job, null);
        }
    }

    @NotNull
    public MethodResult resume(Object[] objects) {
        if (this.result != null) {
            return this.result;
        }
        if (this.exception != null) {
            return MethodResult.of((Object)this.exception);
        }
        return MethodResult.of();
    }
}

