/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.srendi.advancedperipherals.common.argoggles.ARRenderAction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class HudOverlayHandler {
    private static HudOverlayHandler instance;
    private final List<ARRenderAction> canvas = new ArrayList<ARRenderAction>();

    public static void init() {
        instance = new HudOverlayHandler();
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    public static HudOverlayHandler getInstance() {
        return instance;
    }

    public static void updateCanvas(List<ARRenderAction> actions) {
        if (instance == null) {
            return;
        }
        HudOverlayHandler.instance.canvas.clear();
        HudOverlayHandler.instance.canvas.addAll(actions);
    }

    public static void clearCanvas() {
        if (instance == null) {
            return;
        }
        HudOverlayHandler.instance.canvas.clear();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRender(RenderGameOverlayEvent.Post event) {
        if (event.getWindow() == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        MatrixStack matrixStack = event.getMatrixStack();
        for (ARRenderAction action : this.canvas) {
            action.draw(mc, matrixStack, event.getWindow().func_198105_m(), event.getWindow().func_198083_n());
        }
        mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
    }
}

