/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.findme.proxy;

import com.buuz135.findme.FindMe;
import java.awt.Color;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class FindMeConfig {
    public static Common COMMON = new Common();
    public static Client CLIENT = new Client();

    public static class Common
    extends ConfigClass {
        public ForgeConfigSpec.ConfigValue<Integer> RADIUS_RANGE;
        public ForgeConfigSpec.ConfigValue<Boolean> IGNORE_ITEM_DAMAGE;

        public Common() {
            ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
            BUILDER.push("COMMON");
            this.RADIUS_RANGE = BUILDER.comment("Checking radius centered on the player").defineInRange("RADIUS_RANGE", 8, 0, Integer.MAX_VALUE);
            this.IGNORE_ITEM_DAMAGE = BUILDER.comment("Checks item damage or not").define("IGNORE_ITEM_DAMAGE", false);
            BUILDER.pop();
            this.SPEC = BUILDER.build();
        }

        @Override
        public void onConfigReload(ModConfig.Reloading event) {
            if (event.getConfig().getType() == ModConfig.Type.COMMON) {
                this.SPEC.setConfig(event.getConfig().getConfigData());
            }
        }
    }

    public static class Client
    extends ConfigClass {
        public static final Color DEFAULT_COLOR = Color.decode("#cf9d15");
        public ForgeConfigSpec.ConfigValue<Integer> CONTAINER_TRACK_TIME;
        public ForgeConfigSpec.ConfigValue<Boolean> CONTAINER_TRACKING;
        public ForgeConfigSpec.ConfigValue<String> CONTAINER_HIGHLIGHT;
        private Color currentColor = null;
        private int doTracking = -1;

        public Client() {
            ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
            BUILDER.push("CLIENT");
            this.CONTAINER_TRACK_TIME = BUILDER.comment("How many ticks the searched-for item will be highlighted in containers").defineInRange("CONTAINER_TRACK_TIME", 600, 0, Integer.MAX_VALUE);
            this.CONTAINER_TRACKING = BUILDER.comment("Whether or not tracked items will have their backgrounds highlighted").define("CONTAINER_TRACKING", true);
            this.CONTAINER_HIGHLIGHT = BUILDER.comment("Colour used to highlight container background slots when a tracked item is contained within").define("CONTAINER_HIGHLIGHT", (Object)"#cf9d15");
            BUILDER.pop();
            this.SPEC = BUILDER.build();
        }

        public Color getColor() {
            if (this.currentColor == null) {
                try {
                    this.currentColor = Color.decode(((String)this.CONTAINER_HIGHLIGHT.get()).toLowerCase());
                }
                catch (NumberFormatException e) {
                    FindMe.LOG.error("Unable to parse color value '" + (String)this.CONTAINER_HIGHLIGHT.get() + "'", (Throwable)e);
                    this.currentColor = DEFAULT_COLOR;
                }
            }
            return this.currentColor;
        }

        public boolean doTracking() {
            if (this.doTracking == -1) {
                this.doTracking = (Boolean)this.CONTAINER_TRACKING.get() != false ? 1 : 0;
            }
            return this.doTracking == 1;
        }

        @Override
        public void onConfigReload(ModConfig.Reloading event) {
            if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
                this.SPEC.setConfig(event.getConfig().getConfigData());
                this.currentColor = null;
                this.doTracking = -1;
            }
        }
    }

    private static abstract class ConfigClass {
        public ForgeConfigSpec SPEC;

        private ConfigClass() {
        }

        public abstract void onConfigReload(ModConfig.Reloading var1);
    }
}

