/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.util;

import gdavid.phi.spell.Errors;
import net.minecraft.util.math.BlockPos;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;

public class ParamHelper {
    public static double positiveOrZero(SpellPiece piece, SpellParam<Number> param) throws SpellCompilationException {
        double res = ((Number)piece.getNonNullParamEvaluation(param)).doubleValue();
        if (res < 0.0) {
            Errors.compile("psi.spellerror.nonpositivevalue", piece.x, piece.y);
        }
        return res;
    }

    public static double positive(SpellPiece piece, SpellParam<Number> param) throws SpellCompilationException {
        double res = ((Number)piece.getNonNullParamEvaluation(param)).doubleValue();
        if (res <= 0.0) {
            Errors.compile("psi.spellerror.nonpositivevalue", piece.x, piece.y);
        }
        return res;
    }

    public static Vector3 nonNull(SpellPiece piece, SpellContext context, SpellParam<Vector3> param) throws SpellRuntimeException {
        Vector3 res = (Vector3)piece.getNonnullParamValue(context, param);
        if (res.isZero()) {
            Errors.runtime("psi.spellerror.nullvector");
        }
        return res;
    }

    public static Vector3 inRange(SpellPiece piece, SpellContext context, SpellParam<Vector3> param) throws SpellRuntimeException {
        Vector3 res = ParamHelper.nonNull(piece, context, param);
        if (!context.isInRadius(res)) {
            Errors.runtime("psi.spellerror.outsideradius");
        }
        return res;
    }

    public static BlockPos block(SpellPiece piece, SpellContext context, SpellParam<Vector3> param) throws SpellRuntimeException {
        return ParamHelper.inRange(piece, context, param).toBlockPos();
    }
}

