/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.trick.mpu;

import gdavid.phi.block.tile.MPUTile;
import gdavid.phi.entity.PsiProjectileEntity;
import gdavid.phi.util.ParamHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.server.ServerWorld;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class PsiTransferTrick
extends PieceTrick {
    public static final String flag = "phi:psi_transfer";
    SpellParam<Vector3> direction;
    SpellParam<Number> psi;

    public PsiTransferTrick(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.direction = new ParamVector("psi.spellparam.direction", SpellParam.GREEN, false, false);
        this.addParam((SpellParam)this.direction);
        this.psi = new ParamNumber("psi.spellparam.power", SpellParam.BLUE, false, true);
        this.addParam((SpellParam)this.psi);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        double psiVal = ParamHelper.positive((SpellPiece)this, this.psi);
        meta.addStat(EnumSpellStat.POTENCY, (int)psiVal);
        meta.addStat(EnumSpellStat.COST, (int)Math.ceil(psiVal / 0.98));
        meta.setFlag(flag, true);
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 directionVal = ParamHelper.nonNull((SpellPiece)this, context, this.direction).copy().normalize();
        int psiVal = ((Number)this.getNonnullParamValue(context, this.psi)).intValue();
        if (psiVal == 0) {
            return null;
        }
        if (context.focalPoint.func_130014_f_() instanceof ServerWorld) {
            PsiProjectileEntity projectile = new PsiProjectileEntity(context.focalPoint.func_130014_f_(), directionVal.toVec3D(), psiVal);
            ItemStack cad = PsiAPI.getPlayerCAD((PlayerEntity)context.caster);
            if (!cad.func_190926_b()) {
                projectile.setColorizer(((ICAD)cad.func_77973_b()).getComponentInSlot(cad, EnumCADComponent.DYE));
            }
            projectile.func_70107_b(context.focalPoint.func_226277_ct_(), context.focalPoint.func_226278_cu_() + (double)context.focalPoint.func_70047_e() - (context.focalPoint instanceof MPUTile.MPUCaster ? 0.0 : 0.5), context.focalPoint.func_226281_cx_());
            projectile.setOrigin();
            projectile.func_130014_f_().func_217376_c((Entity)projectile);
        }
        return null;
    }
}

