/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.trick.marker;

import gdavid.phi.entity.MarkerEntity;
import gdavid.phi.spell.Errors;
import gdavid.phi.util.ParamHelper;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import vazkii.psi.api.internal.MathHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class ConjureMarkerTrick
extends PieceTrick {
    SpellParam<Vector3> position;
    SpellParam<Number> time;

    public ConjureMarkerTrick(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam((SpellParam)this.position);
        this.time = new ParamNumber("psi.spellparam.time", SpellParam.PURPLE, false, true);
        this.addParam((SpellParam)this.time);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        Double timeVal = ((Number)this.getNonNullParamEvaluation(this.time)).doubleValue();
        if (timeVal <= 0.0 || timeVal != (double)timeVal.intValue()) {
            Errors.compile("psi.spellerror.nonpositiveinteger");
        }
        meta.addStat(EnumSpellStat.POTENCY, (int)Math.max(1.0, timeVal / 5.0));
        meta.addStat(EnumSpellStat.COST, (int)Math.max(1.0, timeVal / 20.0));
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 positionVal = ParamHelper.nonNull((SpellPiece)this, context, this.position);
        int timeVal = ((Number)this.getNonnullParamValue(context, this.time)).intValue();
        if (timeVal < 1) {
            Errors.runtime("psi.spellerror.nonpositivevalue");
        }
        if (MathHelper.pointDistanceSpace((double)positionVal.x, (double)positionVal.y, (double)positionVal.z, (double)context.focalPoint.func_226277_ct_(), (double)context.focalPoint.func_226278_cu_(), (double)context.focalPoint.func_226281_cx_()) > 64.0) {
            Errors.runtime("psi.spellerror.outsideradius");
        }
        World world = context.focalPoint.func_130014_f_();
        MarkerEntity marker = new MarkerEntity(world, (Entity)context.caster, timeVal);
        marker.func_70107_b(positionVal.x, positionVal.y, positionVal.z);
        world.func_217376_c((Entity)marker);
        return marker;
    }

    public Class<?> getEvaluationType() {
        return Entity.class;
    }
}

