/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.trick.evaluation;

import gdavid.phi.spell.Errors;
import gdavid.phi.spell.Param;
import gdavid.phi.spell.param.ReferenceParam;
import gdavid.phi.util.EvalHelper;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.piece.PieceTrick;

public class EarlyEvaluateTrick
extends PieceTrick {
    ReferenceParam target;
    SpellParam<Number> condition;

    public EarlyEvaluateTrick(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.target = new ReferenceParam("psi.spellparam.target", SpellParam.RED, false);
        this.addParam((SpellParam)this.target);
        this.condition = new ParamNumber(Param.condition.name, SpellParam.BLUE, false, false);
        this.addParam((SpellParam)this.condition);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        meta.addStat(EnumSpellStat.COMPLEXITY, 1);
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        if (Math.abs(((Number)this.getNonnullParamValue(context, this.condition)).doubleValue()) >= 1.0) {
            return null;
        }
        try {
            SpellPiece piece = this.spell.grid.getPieceAtSideWithRedirections(this.x, this.y, (SpellParam.Side)this.paramSides.get((Object)this.target));
            EvalHelper.hoist(piece, context);
        }
        catch (SpellCompilationException e) {
            Errors.errored.runtime();
        }
        return null;
    }
}

