/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.trick.blink;

import gdavid.phi.spell.Errors;
import gdavid.phi.spell.Param;
import gdavid.phi.util.ParamHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamEntity;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.piece.PieceTrick;

public class SwapBlinkTrick
extends PieceTrick {
    SpellParam<Entity> a;
    SpellParam<Entity> b;
    SpellParam<Number> distance;

    public SwapBlinkTrick(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.a = new ParamEntity(Param.target1.name, SpellParam.YELLOW, false, false);
        this.addParam((SpellParam)this.a);
        this.b = new ParamEntity(Param.target2.name, SpellParam.YELLOW, true, false);
        this.addParam((SpellParam)this.b);
        this.distance = new ParamNumber("psi.spellparam.distance", SpellParam.RED, false, true);
        this.addParam((SpellParam)this.distance);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        double maxDistance = ParamHelper.positive((SpellPiece)this, this.distance);
        meta.addStat(EnumSpellStat.POTENCY, (int)(Math.sqrt(2.0 * maxDistance) * 40.0));
        meta.addStat(EnumSpellStat.COST, (int)(maxDistance * 40.0));
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        ServerPlayNetHandler c;
        Vector3d offset;
        double distanceVal = ((Number)this.getNonnullParamValue(context, this.distance)).doubleValue();
        Entity e1 = (Entity)this.getNonnullParamValue(context, this.a);
        Entity e2 = (Entity)this.getParamValueOrDefault(context, this.b, context.caster);
        context.verifyEntity(e1);
        context.verifyEntity(e2);
        if (!context.isInRadius(e1) || !context.isInRadius(e2)) {
            Errors.runtime("psi.spellerror.outsideradius");
        }
        if ((offset = e2.func_213303_ch().func_178788_d(e1.func_213303_ch())).func_189985_c() > distanceVal * distanceVal) {
            return null;
        }
        Vector3d pos1 = e1.func_213303_ch();
        Vector2f rot1 = e1.func_189653_aC();
        float rotyh1 = e1.func_70079_am();
        e1.func_70080_a(e2.func_226277_ct_(), e2.func_226278_cu_(), e2.func_226281_cx_(), e2.field_70177_z, e2.field_70125_A);
        e1.func_70034_d(e2.func_70079_am());
        if (e1 instanceof ServerPlayerEntity) {
            c = ((ServerPlayerEntity)e1).field_71135_a;
            c.func_147364_a(e2.func_226277_ct_(), e2.func_226278_cu_(), e2.func_226281_cx_(), e2.field_70177_z, e2.field_70125_A);
            c.func_184342_d();
        }
        e2.func_70080_a(pos1.field_72450_a, pos1.field_72448_b, pos1.field_72449_c, rot1.field_189983_j, rot1.field_189982_i);
        e2.func_70034_d(rotyh1);
        if (e2 instanceof ServerPlayerEntity) {
            c = ((ServerPlayerEntity)e2).field_71135_a;
            c.func_147364_a(pos1.field_72450_a, pos1.field_72448_b, pos1.field_72449_c, rot1.field_189983_j, rot1.field_189982_i);
            c.func_184342_d();
        }
        return null;
    }
}

