/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.trick;

import gdavid.phi.block.ModBlocks;
import gdavid.phi.util.ParamHelper;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class ShadowTrick
extends PieceTrick {
    SpellParam<Vector3> position;
    SpellParam<Number> time;

    public ShadowTrick(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam((SpellParam)this.position);
        this.time = new ParamNumber("psi.spellparam.time", SpellParam.PURPLE, false, false);
        this.addParam((SpellParam)this.time);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        int timeVal = (int)ParamHelper.positive((SpellPiece)this, this.time);
        meta.addStat(EnumSpellStat.POTENCY, timeVal / 2);
        meta.addStat(EnumSpellStat.COST, 40);
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        BlockPos pos = ParamHelper.block((SpellPiece)this, context, this.position);
        int timeVal = ((Number)this.getNonnullParamValue(context, this.time)).intValue();
        World world = context.focalPoint.func_130014_f_();
        if (!world.func_175667_e(pos) || !world.func_175660_a(context.caster, pos)) {
            return null;
        }
        BlockState block = world.func_180495_p(pos);
        if ((block.isAir((IBlockReader)world, pos) || block.func_185904_a().func_76222_j()) && world.func_175656_a(pos, ModBlocks.shadow.func_176223_P())) {
            world.func_205220_G_().func_205360_a(pos, (Object)ModBlocks.shadow, timeVal);
        }
        return null;
    }
}

