/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.trick;

import gdavid.phi.block.ModBlocks;
import gdavid.phi.spell.Errors;
import gdavid.phi.util.ParamHelper;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import vazkii.psi.api.internal.MathHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class ShadowSequenceTrick
extends PieceTrick {
    SpellParam<Vector3> position;
    SpellParam<Number> time;
    SpellParam<Vector3> target;
    SpellParam<Number> maxBlocks;

    public ShadowSequenceTrick(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam((SpellParam)this.position);
        this.time = new ParamNumber("psi.spellparam.time", SpellParam.PURPLE, false, false);
        this.addParam((SpellParam)this.time);
        this.target = new ParamVector("psi.spellparam.target", SpellParam.GREEN, false, false);
        this.addParam((SpellParam)this.target);
        this.maxBlocks = new ParamNumber("psi.spellparam.max", SpellParam.RED, false, false);
        this.addParam((SpellParam)this.maxBlocks);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        int timeVal = (int)ParamHelper.positive((SpellPiece)this, this.time);
        int max = (int)ParamHelper.positive((SpellPiece)this, this.maxBlocks);
        meta.addStat(EnumSpellStat.POTENCY, timeVal / 2 * max);
        meta.addStat(EnumSpellStat.COST, 40 + 20 * (max - 1));
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 pos = ParamHelper.nonNull((SpellPiece)this, context, this.position);
        int timeVal = ((Number)this.getNonnullParamValue(context, this.time)).intValue();
        int max = ((Number)this.getNonnullParamValue(context, this.maxBlocks)).intValue();
        Vector3 to = ParamHelper.nonNull((SpellPiece)this, context, this.target).copy().normalize().multiply((double)max);
        World world = context.focalPoint.func_130014_f_();
        for (BlockPos at : MathHelper.getBlocksAlongRay((Vector3d)pos.toVec3D(), (Vector3d)pos.copy().add(to).toVec3D(), (int)max)) {
            BlockState block;
            if (!context.isInRadius(Vector3.fromBlockPos((BlockPos)at))) {
                Errors.runtime("psi.spellerror.outsideradius");
            }
            if (!world.func_175667_e(at) || !world.func_175660_a(context.caster, at) || !(block = world.func_180495_p(at)).isAir((IBlockReader)world, at) && !block.func_185904_a().func_76222_j() || !world.func_175656_a(at, ModBlocks.shadow.func_176223_P())) continue;
            world.func_205220_G_().func_205360_a(at, (Object)ModBlocks.shadow, timeVal);
        }
        return null;
    }
}

