/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.trick;

import gdavid.phi.spell.Errors;
import gdavid.phi.util.ParamHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.piece.PieceTrick;

public class SaveVectorComponentTrick
extends PieceTrick {
    public static final String vectorLocked = "psi:SlotLocked";
    SpellParam<Number> target;
    SpellParam<Number> number;

    public SaveVectorComponentTrick(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.target = new ParamNumber("psi.spellparam.target", SpellParam.BLUE, false, true);
        this.addParam((SpellParam)this.target);
        this.number = new ParamNumber("psi.spellparam.number", SpellParam.RED, false, false);
        this.addParam((SpellParam)this.number);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        meta.addStat(EnumSpellStat.COMPLEXITY, 1);
        double lastTarget = ParamHelper.positive((SpellPiece)this, this.target);
        meta.addStat(EnumSpellStat.POTENCY, (int)(lastTarget * 2.0));
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        int targetVal = ((Number)this.getParamValue(context, this.target)).intValue() - 1;
        int n = targetVal / 3;
        int c = targetVal % 3;
        ItemStack cad = PsiAPI.getPlayerCAD((PlayerEntity)context.caster);
        if (!(cad.func_77973_b() instanceof ICAD)) {
            Errors.runtime("psi.spellerror.nocad");
        }
        Vector3 vec = ((ICAD)cad.func_77973_b()).getStoredVector(cad, n).copy();
        SaveVectorComponentTrick.setComponent(vec, c, ((Number)this.getNonnullParamValue(context, this.number)).doubleValue());
        ((ICAD)cad.func_77973_b()).setStoredVector(cad, n, vec);
        SaveVectorComponentTrick.lock(context, n, c);
        return null;
    }

    public static void lock(SpellContext context, int n, int c) {
        if (context.customData.containsKey(vectorLocked + n)) {
            int lock = (Integer)context.customData.get(vectorLocked + n);
            if (lock != 0) {
                context.customData.put(vectorLocked + n, lock | 1 << c);
            }
        } else {
            context.customData.put(vectorLocked + n, 1 << c);
        }
    }

    public static Vector3 setComponent(Vector3 vec, int c, double num) {
        if (c == 0) {
            vec.x = num;
        } else if (c == 1) {
            vec.y = num;
        } else {
            vec.z = num;
        }
        return vec;
    }
}

