/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.selector;

import gdavid.phi.spell.Errors;
import gdavid.phi.util.ParamHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.piece.PieceSelector;

public class SavedVectorComponentSelector
extends PieceSelector {
    SpellParam<Number> target;

    public SavedVectorComponentSelector(Spell spell) {
        super(spell);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        double lastTarget = ParamHelper.positive((SpellPiece)this, this.target);
        meta.addStat(EnumSpellStat.POTENCY, (int)(lastTarget * 2.0));
    }

    public void initParams() {
        this.target = new ParamNumber("psi.spellparam.target", SpellParam.BLUE, false, true);
        this.addParam((SpellParam)this.target);
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        ItemStack cad;
        int c;
        int targetVal = ((Number)this.getParamValue(context, this.target)).intValue() - 1;
        int n = targetVal / 3;
        if (SavedVectorComponentSelector.isLocked(context, n, c = targetVal % 3)) {
            Errors.runtime("psi.spellerror.lockedmemory");
        }
        if (!((cad = PsiAPI.getPlayerCAD((PlayerEntity)context.caster)).func_77973_b() instanceof ICAD)) {
            Errors.runtime("psi.spellerror.nocad");
        }
        return SavedVectorComponentSelector.getComponent(((ICAD)cad.func_77973_b()).getStoredVector(cad, n), c);
    }

    public static boolean isLocked(SpellContext context, int n, int c) {
        if (!context.customData.containsKey("psi:SlotLocked" + n)) {
            return false;
        }
        int val = (Integer)context.customData.get("psi:SlotLocked" + n);
        return val == 0 || (val & 1 << c) != 0;
    }

    public static double getComponent(Vector3 v, int c) {
        if (c == 0) {
            return v.x;
        }
        if (c == 1) {
            return v.y;
        }
        return v.z;
    }

    public Class<?> getEvaluationType() {
        return Double.class;
    }
}

