/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.selector;

import gdavid.phi.entity.MarkerEntity;
import gdavid.phi.spell.Errors;
import java.util.List;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import vazkii.psi.api.internal.MathHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceSelector;
import vazkii.psi.api.spell.wrapper.EntityListWrapper;

public class NearbyMarkersSelector
extends PieceSelector {
    SpellParam<Vector3> position;
    SpellParam<Number> radius;

    public NearbyMarkersSelector(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, true, false);
        this.addParam((SpellParam)this.position);
        this.radius = new ParamNumber("psi.spellparam.radius", SpellParam.GREEN, true, false);
        this.addParam((SpellParam)this.radius);
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 positionVal = (Vector3)this.getParamValueOrDefault(context, this.position, Vector3.fromVec3d((Vector3d)context.focalPoint.func_213303_ch()));
        double radiusVal = ((Number)this.getParamValueOrDefault(context, this.radius, 64.0)).doubleValue();
        if (radiusVal <= 0.0) {
            Errors.runtime("psi.spellerror.nonpositivevalue");
        }
        if (MathHelper.pointDistanceSpace((double)positionVal.x, (double)positionVal.y, (double)positionVal.z, (double)context.focalPoint.func_226277_ct_(), (double)context.focalPoint.func_226278_cu_(), (double)context.focalPoint.func_226281_cx_()) > 64.0) {
            Errors.runtime("psi.spellerror.outsideradius");
        }
        AxisAlignedBB boundingBox = AxisAlignedBB.func_241550_g_((double)radiusVal, (double)radiusVal, (double)radiusVal).func_191194_a(positionVal.toVec3D());
        boundingBox = boundingBox.func_191500_a(AxisAlignedBB.func_241550_g_((double)64.0, (double)64.0, (double)64.0).func_191194_a(context.focalPoint.func_213303_ch()));
        return EntityListWrapper.make((List)context.focalPoint.func_130014_f_().func_217357_a(MarkerEntity.class, boundingBox));
    }

    public Class<?> getEvaluationType() {
        return EntityListWrapper.class;
    }
}

