/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.operator.vector;

import gdavid.phi.spell.Errors;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceOperator;

public class ClampVectorOperator
extends PieceOperator {
    SpellParam<Vector3> vector;
    SpellParam<Number> max;

    public ClampVectorOperator(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.vector = new ParamVector("psi.spellparam.vector", SpellParam.GREEN, false, false);
        this.addParam((SpellParam)this.vector);
        this.max = new ParamNumber("psi.spellparam.max", SpellParam.RED, false, false);
        this.addParam((SpellParam)this.max);
    }

    public Class<?> getEvaluationType() {
        return Vector3.class;
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 vec = (Vector3)this.getNonnullParamValue(context, this.vector);
        double maxLength = ((Number)this.getNonnullParamValue(context, this.max)).doubleValue();
        if (maxLength < 0.0) {
            Errors.runtime("psi.spellerror.negativenumber");
        }
        if (vec.magSquared() > maxLength * maxLength) {
            return vec.copy().normalize().multiply(maxLength);
        }
        return vec;
    }
}

