/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.operator.text;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import gdavid.phi.spell.Errors;
import gdavid.phi.spell.Param;
import gdavid.phi.spell.param.ReferenceParam;
import gdavid.phi.spell.param.TextParam;
import gdavid.phi.util.ISidedResult;
import gdavid.phi.util.RenderHelper;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.ClientPsiAPI;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.piece.PieceOperator;

public class SplitTextOperator
extends PieceOperator {
    public static final ResourceLocation lineTexture = new ResourceLocation("phi", "spell/operator_split_text_lines");
    public SpellParam<String> text;
    public SpellParam<Number> position;
    ReferenceParam before;
    ReferenceParam after;

    public SplitTextOperator(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.text = new TextParam(Param.text.name, SpellParam.GRAY, false, false);
        this.addParam((SpellParam)this.text);
        this.position = new ParamNumber("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam((SpellParam)this.position);
        this.before = new ReferenceParam(Param.before.name, SpellParam.RED, true, SpellParam.ArrowType.NONE);
        this.addParam((SpellParam)this.before);
        this.after = new ReferenceParam(Param.after.name, SpellParam.GREEN, true, SpellParam.ArrowType.NONE);
        this.addParam((SpellParam)this.after);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawAdditional(MatrixStack ms, IRenderTypeBuffer buffers, int light) {
        this.drawLine(ms, buffers, light, -1, (SpellParam.Side)this.paramSides.get(this.text));
        this.drawLine(ms, buffers, light, -1, (SpellParam.Side)this.paramSides.get(this.position));
        this.drawLine(ms, buffers, light, this.before.color, (SpellParam.Side)this.paramSides.get((Object)this.before));
        this.drawLine(ms, buffers, light, this.after.color, (SpellParam.Side)this.paramSides.get((Object)this.after));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawLine(MatrixStack ms, IRenderTypeBuffer buffers, int light, int color, SpellParam.Side side) {
        if (!side.isEnabled()) {
            return;
        }
        RenderMaterial material = new RenderMaterial(ClientPsiAPI.PSI_PIECE_TEXTURE_ATLAS, lineTexture);
        IVertexBuilder buffer = material.func_229311_a_(buffers, get -> SpellPiece.getLayer());
        float minU = side == SpellParam.Side.LEFT || side == SpellParam.Side.BOTTOM ? 0.5f : 0.0f;
        float minV = side == SpellParam.Side.TOP || side == SpellParam.Side.BOTTOM ? 0.5f : 0.0f;
        float maxU = minU + 0.5f;
        float maxV = minV + 0.5f;
        int r = RenderHelper.r(color);
        int g = RenderHelper.g(color);
        int b = RenderHelper.b(color);
        int a = 255;
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(mat, 0.0f, 16.0f, 0.0f).func_225586_a_(r, g, b, a);
        buffer.func_225583_a_(minU, maxV).func_227886_a_(light).func_181675_d();
        buffer.func_227888_a_(mat, 16.0f, 16.0f, 0.0f).func_225586_a_(r, g, b, a);
        buffer.func_225583_a_(maxU, maxV).func_227886_a_(light).func_181675_d();
        buffer.func_227888_a_(mat, 16.0f, 0.0f, 0.0f).func_225586_a_(r, g, b, a);
        buffer.func_225583_a_(maxU, minV).func_227886_a_(light).func_181675_d();
        buffer.func_227888_a_(mat, 0.0f, 0.0f, 0.0f).func_225586_a_(r, g, b, a);
        buffer.func_225583_a_(minU, minV).func_227886_a_(light).func_181675_d();
    }

    public Class<?> getEvaluationType() {
        return String.class;
    }

    public boolean isInputSide(SpellParam.Side side) {
        return this.paramSides.get(this.text) == side || this.paramSides.get(this.position) == side;
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        String str = (String)this.getParamValue(context, this.text);
        int pos = Math.min(str.length(), Math.max(0, ((Number)this.getParamValue(context, this.position)).intValue() - 1));
        return new Result(str, pos, (SpellParam.Side)this.paramSides.get((Object)this.before), (SpellParam.Side)this.paramSides.get((Object)this.after));
    }

    public static class Result
    implements ISidedResult {
        public final String before;
        public final String after;
        public final SpellParam.Side sbefore;
        public final SpellParam.Side safter;

        public Result(String str, int pos, SpellParam.Side sbefore, SpellParam.Side safter) {
            this.before = str.substring(0, pos);
            this.after = str.substring(pos);
            this.sbefore = sbefore;
            this.safter = safter;
        }

        @Override
        public Object get(SpellParam.Side side) throws SpellRuntimeException {
            if (side == this.sbefore) {
                return this.before;
            }
            if (side == this.safter) {
                return this.after;
            }
            Errors.runtime("psi.spellerror.invalidparam");
            return null;
        }
    }
}

