/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.operator.number;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import gdavid.phi.spell.Errors;
import gdavid.phi.spell.Param;
import gdavid.phi.spell.param.ReferenceParam;
import gdavid.phi.util.ISidedResult;
import gdavid.phi.util.RenderHelper;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.ClientPsiAPI;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.piece.PieceOperator;

public class DivModOperator
extends PieceOperator {
    public static final ResourceLocation lineTexture = new ResourceLocation("phi", "spell/operator_div_mod_lines");
    public SpellParam<Number> a;
    public SpellParam<Number> b;
    ReferenceParam div;
    ReferenceParam mod;

    public DivModOperator(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.a = new ParamNumber("psi.spellparam.number1", SpellParam.RED, false, false);
        this.addParam((SpellParam)this.a);
        this.b = new ParamNumber("psi.spellparam.number2", SpellParam.GREEN, false, false);
        this.addParam((SpellParam)this.b);
        this.div = new ReferenceParam(Param.div.name, SpellParam.RED, true, SpellParam.ArrowType.NONE);
        this.addParam((SpellParam)this.div);
        this.mod = new ReferenceParam(Param.mod.name, SpellParam.GREEN, true, SpellParam.ArrowType.NONE);
        this.addParam((SpellParam)this.mod);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawAdditional(MatrixStack ms, IRenderTypeBuffer buffers, int light) {
        this.drawLine(ms, buffers, light, -1, (SpellParam.Side)this.paramSides.get(this.a));
        this.drawLine(ms, buffers, light, -1, (SpellParam.Side)this.paramSides.get(this.b));
        this.drawLine(ms, buffers, light, this.div.color, (SpellParam.Side)this.paramSides.get((Object)this.div));
        this.drawLine(ms, buffers, light, this.mod.color, (SpellParam.Side)this.paramSides.get((Object)this.mod));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawLine(MatrixStack ms, IRenderTypeBuffer buffers, int light, int color, SpellParam.Side side) {
        if (!side.isEnabled()) {
            return;
        }
        RenderMaterial material = new RenderMaterial(ClientPsiAPI.PSI_PIECE_TEXTURE_ATLAS, lineTexture);
        IVertexBuilder buffer = material.func_229311_a_(buffers, get -> SpellPiece.getLayer());
        float minU = side == SpellParam.Side.LEFT || side == SpellParam.Side.BOTTOM ? 0.5f : 0.0f;
        float minV = side == SpellParam.Side.TOP || side == SpellParam.Side.BOTTOM ? 0.5f : 0.0f;
        float maxU = minU + 0.5f;
        float maxV = minV + 0.5f;
        int r = RenderHelper.r(color);
        int g = RenderHelper.g(color);
        int b = RenderHelper.b(color);
        int a = 255;
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(mat, 0.0f, 16.0f, 0.0f).func_225586_a_(r, g, b, a);
        buffer.func_225583_a_(minU, maxV).func_227886_a_(light).func_181675_d();
        buffer.func_227888_a_(mat, 16.0f, 16.0f, 0.0f).func_225586_a_(r, g, b, a);
        buffer.func_225583_a_(maxU, maxV).func_227886_a_(light).func_181675_d();
        buffer.func_227888_a_(mat, 16.0f, 0.0f, 0.0f).func_225586_a_(r, g, b, a);
        buffer.func_225583_a_(maxU, minV).func_227886_a_(light).func_181675_d();
        buffer.func_227888_a_(mat, 0.0f, 0.0f, 0.0f).func_225586_a_(r, g, b, a);
        buffer.func_225583_a_(minU, minV).func_227886_a_(light).func_181675_d();
    }

    public Class<?> getEvaluationType() {
        return Double.class;
    }

    public boolean isInputSide(SpellParam.Side side) {
        return this.paramSides.get(this.a) == side || this.paramSides.get(this.b) == side;
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        Double av = ((Number)this.getParamValue(context, this.a)).doubleValue();
        Double bv = ((Number)this.getParamValue(context, this.b)).doubleValue();
        if (bv == 0.0) {
            Errors.runtime("psi.spellerror.dividebyzero");
        }
        return new Result(av, bv, (SpellParam.Side)this.paramSides.get((Object)this.div), (SpellParam.Side)this.paramSides.get((Object)this.mod));
    }

    public static class Result
    implements ISidedResult {
        public final Double div;
        public final Double mod;
        public final SpellParam.Side sdiv;
        public final SpellParam.Side smod;

        public Result(double a, double b, SpellParam.Side sdiv, SpellParam.Side smod) {
            this.div = Math.floor(a / b);
            this.mod = a % b;
            this.sdiv = sdiv;
            this.smod = smod;
        }

        @Override
        public Object get(SpellParam.Side side) throws SpellRuntimeException {
            if (side == this.sdiv) {
                return this.div;
            }
            if (side == this.smod) {
                return this.mod;
            }
            Errors.runtime("psi.spellerror.invalidparam");
            return null;
        }
    }
}

