/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.operator;

import gdavid.phi.spell.Errors;
import gdavid.phi.spell.Param;
import gdavid.phi.util.EvalHelper;
import gdavid.phi.util.TypeHelper;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamAny;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.piece.PieceOperator;

public class BranchOperator
extends PieceOperator {
    SpellParam<SpellParam.Any> positive;
    SpellParam<SpellParam.Any> negative;
    SpellParam<Number> condition;

    public BranchOperator(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.positive = new ParamAny(Param.positive.name, SpellParam.RED, false);
        this.addParam((SpellParam)this.positive);
        this.negative = new ParamAny(Param.negative.name, SpellParam.GREEN, false);
        this.addParam((SpellParam)this.negative);
        this.condition = new ParamNumber(Param.condition.name, SpellParam.BLUE, false, false);
        this.addParam((SpellParam)this.condition);
    }

    public Class<?> getEvaluationType() {
        if (!this.isInGrid || this.paramSides.get(this.positive) == SpellParam.Side.OFF || this.paramSides.get(this.negative) == SpellParam.Side.OFF) {
            return SpellParam.Any.class;
        }
        try {
            SpellPiece piece1 = this.spell.grid.getPieceAtSideWithRedirections(this.x, this.y, (SpellParam.Side)this.paramSides.get(this.positive));
            if (piece1 == null || EvalHelper.isLoop(piece1)) {
                return SpellParam.Any.class;
            }
            SpellPiece piece2 = this.spell.grid.getPieceAtSideWithRedirections(this.x, this.y, (SpellParam.Side)this.paramSides.get(this.negative));
            if (piece2 == null || EvalHelper.isLoop(piece2)) {
                return SpellParam.Any.class;
            }
            Class<?> clazz = TypeHelper.commonSuper(piece1.getEvaluationType(), piece2.getEvaluationType());
            return clazz == null ? Object.class : clazz;
        }
        catch (SpellCompilationException e) {
            return SpellParam.Any.class;
        }
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        Object b;
        Double cond = ((Number)this.getParamValue(context, this.condition)).doubleValue();
        if (cond > 0.0) {
            return this.getRawParamValue(context, this.positive);
        }
        if (cond < 0.0) {
            return this.getRawParamValue(context, this.negative);
        }
        Object a = this.getRawParamValue(context, this.positive);
        if (!a.equals(b = this.getRawParamValue(context, this.negative))) {
            Errors.ambiguous.runtime();
        }
        return a;
    }
}

