/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.constant;

import com.mojang.blaze3d.matrix.MatrixStack;
import gdavid.phi.spell.Param;
import gdavid.phi.spell.param.TextParam;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;

public class TextConstant
extends SpellPiece {
    public static final String tagValue = "value";
    SpellParam<String> prefix;
    public String str;

    public TextConstant(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.prefix = new TextParam(Param.pre.name, SpellParam.GRAY, true, true);
        this.addParam((SpellParam)this.prefix);
        this.str = "";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawAdditional(MatrixStack ms, IRenderTypeBuffer buffers, int light) {
        if (this.str.length() > 5) {
            this.str = this.str.substring(0, 5);
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        String rstr = this.str.replaceAll(" ", "\u00a78_\u00a7r");
        if (rstr.length() == 0) {
            rstr = "\u00a78Text";
        }
        ms.func_227860_a_();
        ms.func_227861_a_((double)(8.0f - (float)font.func_78256_a(rstr) / 4.0f), 4.0, 0.0);
        ms.func_227862_a_(0.5f, 0.5f, 1.0f);
        font.func_228079_a_(rstr, 0.0f, 0.0f, 0xFFFFFF, false, ms.func_227866_c_().func_227870_a_(), buffers, false, 0, light);
        ms.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean interceptKeystrokes() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean onCharTyped(char ch, int key, boolean doit) {
        if (this.str.length() + 1 > 5) {
            return false;
        }
        if (ch < ' ' || ch > '~') {
            return false;
        }
        if (doit) {
            this.str = this.str + ch;
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean onKeyPressed(int key, int scanCode, boolean doit) {
        if (this.str.length() == 0) {
            return false;
        }
        if (key == 259) {
            if (doit) {
                this.str = this.str.substring(0, this.str.length() - 1);
            }
            return true;
        }
        return false;
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        if (this.str.length() > 5) {
            this.str = this.str.substring(0, 5);
        }
        if (((SpellParam.Side)this.paramSides.get(this.prefix)).isEnabled()) {
            return (String)this.getParamValue(context, this.prefix) + this.str;
        }
        return this.str;
    }

    public void writeToNBT(CompoundNBT nbt) {
        super.writeToNBT(nbt);
        nbt.func_74778_a(tagValue, this.str);
    }

    public void readFromNBT(CompoundNBT nbt) {
        super.readFromNBT(nbt);
        this.str = nbt.func_74779_i(tagValue);
    }

    public Class<?> getEvaluationType() {
        return String.class;
    }

    public EnumPieceType getPieceType() {
        return EnumPieceType.CONSTANT;
    }

    public Object evaluate() throws SpellCompilationException {
        if (this.str.length() > 5) {
            this.str = this.str.substring(0, 5);
        }
        if (((SpellParam.Side)this.paramSides.get(this.prefix)).isEnabled()) {
            return this.getParamEvaluation(this.prefix) + this.str;
        }
        return this.str;
    }
}

