/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.connector;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import gdavid.phi.spell.Param;
import gdavid.phi.spell.connector.BidirectionalConnector;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.ClientPsiAPI;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.IGenericRedirector;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamAny;

public class InOutConnector
extends SpellPiece
implements IGenericRedirector {
    public ParamAny from;
    public ParamAny bidir;
    public ParamAny to;

    public InOutConnector(Spell spell) {
        super(spell);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        meta.addStat(EnumSpellStat.COMPLEXITY, 1);
    }

    public void initParams() {
        this.from = new ParamAny(Param.from.name, SpellParam.GRAY, false);
        this.addParam((SpellParam)this.from);
        this.bidir = new ParamAny(Param.fromTo.name, SpellParam.PURPLE, false);
        this.addParam((SpellParam)this.bidir);
        this.to = new ParamAny(Param.to.name, SpellParam.PURPLE, false, SpellParam.ArrowType.NONE);
        this.addParam((SpellParam)this.to);
    }

    public SpellParam.Side remapSide(SpellParam.Side side) {
        if (side.getOpposite() == this.paramSides.get(this.bidir)) {
            return (SpellParam.Side)this.paramSides.get(this.from);
        }
        if (side.getOpposite() == this.paramSides.get(this.to)) {
            return (SpellParam.Side)this.paramSides.get(this.bidir);
        }
        return SpellParam.Side.OFF;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawAdditional(MatrixStack ms, IRenderTypeBuffer buffers, int light) {
        this.drawLine(ms, buffers, light, (SpellParam.Side)this.paramSides.get(this.from), true, false);
        this.drawLine(ms, buffers, light, (SpellParam.Side)this.paramSides.get(this.bidir), true, true);
        this.drawLine(ms, buffers, light, (SpellParam.Side)this.paramSides.get(this.to), false, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawLine(MatrixStack ms, IRenderTypeBuffer buffers, int light, SpellParam.Side side, boolean in, boolean out) {
        if (!side.isEnabled()) {
            return;
        }
        RenderMaterial material = new RenderMaterial(ClientPsiAPI.PSI_PIECE_TEXTURE_ATLAS, BidirectionalConnector.lineTexture);
        IVertexBuilder buffer = material.func_229311_a_(buffers, get -> SpellPiece.getLayer());
        int minX = 0;
        int minY = 0;
        int maxX = 16;
        int maxY = 16;
        float minU = side == SpellParam.Side.LEFT || side == SpellParam.Side.BOTTOM ? 0.5f : 0.0f;
        float minV = side == SpellParam.Side.TOP || side == SpellParam.Side.BOTTOM ? 0.5f : 0.0f;
        float maxU = minU + 0.5f;
        float maxV = minV + 0.5f;
        if (side == SpellParam.Side.LEFT || side == SpellParam.Side.RIGHT) {
            if (!in) {
                minY += 8;
                minV += 0.25f;
            }
            if (!out) {
                maxY -= 8;
                maxV -= 0.25f;
            }
        } else if (side == SpellParam.Side.TOP || side == SpellParam.Side.BOTTOM) {
            if (!in) {
                minX += 8;
                minU += 0.25f;
            }
            if (!out) {
                maxX -= 8;
                maxU -= 0.25f;
            }
        }
        int r = 255;
        int g = 255;
        int b = 255;
        int a = 255;
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(mat, (float)minX, (float)maxY, 0.0f).func_225586_a_(r, g, b, a);
        buffer.func_225583_a_(minU, maxV).func_227886_a_(light).func_181675_d();
        buffer.func_227888_a_(mat, (float)maxX, (float)maxY, 0.0f).func_225586_a_(r, g, b, a);
        buffer.func_225583_a_(maxU, maxV).func_227886_a_(light).func_181675_d();
        buffer.func_227888_a_(mat, (float)maxX, (float)minY, 0.0f).func_225586_a_(r, g, b, a);
        buffer.func_225583_a_(maxU, minV).func_227886_a_(light).func_181675_d();
        buffer.func_227888_a_(mat, (float)minX, (float)minY, 0.0f).func_225586_a_(r, g, b, a);
        buffer.func_225583_a_(minU, minV).func_227886_a_(light).func_181675_d();
    }

    public String getSortingName() {
        return "00000000000";
    }

    public EnumPieceType getPieceType() {
        return EnumPieceType.CONNECTOR;
    }

    public Class<?> getEvaluationType() {
        return SpellParam.Any.class;
    }

    public Object evaluate() throws SpellCompilationException {
        return null;
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        return null;
    }

    public boolean isInputSide(SpellParam.Side side) {
        return this.paramSides.get(this.from) == side || this.paramSides.get(this.bidir) == side;
    }
}

