/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.spell.connector;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import gdavid.phi.spell.Param;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.ClientPsiAPI;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.IGenericRedirector;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamAny;

public class BidirectionalConnector
extends SpellPiece
implements IGenericRedirector {
    public static final ResourceLocation lineTexture = new ResourceLocation("phi", "spell/connector_bidirectional_lines");
    ParamAny a;
    ParamAny b;

    public BidirectionalConnector(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.a = new ParamAny(Param.fromTo.name, SpellParam.GRAY, false);
        this.addParam((SpellParam)this.a);
        this.b = new ParamAny(Param.toFrom.name, SpellParam.GRAY, false);
        this.addParam((SpellParam)this.b);
    }

    public SpellParam.Side remapSide(SpellParam.Side side) {
        if (side.getOpposite() == this.paramSides.get(this.a)) {
            return (SpellParam.Side)this.paramSides.get(this.b);
        }
        if (side.getOpposite() == this.paramSides.get(this.b)) {
            return (SpellParam.Side)this.paramSides.get(this.a);
        }
        return SpellParam.Side.OFF;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawAdditional(MatrixStack ms, IRenderTypeBuffer buffers, int light) {
        this.drawLine(ms, buffers, light, (SpellParam.Side)this.paramSides.get(this.a));
        this.drawLine(ms, buffers, light, (SpellParam.Side)this.paramSides.get(this.b));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawLine(MatrixStack ms, IRenderTypeBuffer buffers, int light, SpellParam.Side side) {
        if (!side.isEnabled()) {
            return;
        }
        RenderMaterial material = new RenderMaterial(ClientPsiAPI.PSI_PIECE_TEXTURE_ATLAS, lineTexture);
        IVertexBuilder buffer = material.func_229311_a_(buffers, get -> SpellPiece.getLayer());
        float minU = side == SpellParam.Side.LEFT || side == SpellParam.Side.BOTTOM ? 0.5f : 0.0f;
        float minV = side == SpellParam.Side.TOP || side == SpellParam.Side.BOTTOM ? 0.5f : 0.0f;
        float maxU = minU + 0.5f;
        float maxV = minV + 0.5f;
        int r = 255;
        int g = 255;
        int b = 255;
        int a = 255;
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(mat, 0.0f, 16.0f, 0.0f).func_225586_a_(r, g, b, a);
        buffer.func_225583_a_(minU, maxV).func_227886_a_(light).func_181675_d();
        buffer.func_227888_a_(mat, 16.0f, 16.0f, 0.0f).func_225586_a_(r, g, b, a);
        buffer.func_225583_a_(maxU, maxV).func_227886_a_(light).func_181675_d();
        buffer.func_227888_a_(mat, 16.0f, 0.0f, 0.0f).func_225586_a_(r, g, b, a);
        buffer.func_225583_a_(maxU, minV).func_227886_a_(light).func_181675_d();
        buffer.func_227888_a_(mat, 0.0f, 0.0f, 0.0f).func_225586_a_(r, g, b, a);
        buffer.func_225583_a_(minU, minV).func_227886_a_(light).func_181675_d();
    }

    public String getSortingName() {
        return "00000000000";
    }

    public EnumPieceType getPieceType() {
        return EnumPieceType.CONNECTOR;
    }

    public Class<?> getEvaluationType() {
        return SpellParam.Any.class;
    }

    public Object evaluate() throws SpellCompilationException {
        return null;
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        return null;
    }
}

